# OpenAPIClient-php

# MyWell Platform API

This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.

## Authentication

### Token Exchange Endpoints

**Initial Token Exchange (`GET /api/v2/auth/access`):**
- Requires: `ACCESS_TOKEN` header only
- Returns: `organizationId` along with tokens

**Refresh Token Exchange (`GET /api/v2/auth/refresh`):**
- Requires: `REFRESH_TOKEN` and `X-Organization` headers

### API Requests

All other API requests require two headers:
1. **X-Authorization**: Bearer token for authentication
2. **X-Organization**: Organization ID that must match the integration's organization

```
X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN
X-Organization: YOUR_ORGANIZATION_ID
```

The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.

## Pagination
Search endpoints support cursor-based pagination:
1. **First Request:** Send request without `cursor`
2. **Response:** Check `pagination.cursor` in response body for next page cursor
3. **Next Request:** Include `cursor` in request body
4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)

**Limit Constraints:**
- Default limit: 20 results per page
- Maximum limit: 100 results per page
- Minimum limit: Must be greater than 0
- Cursors expire after 5 minutes



## Installation & Usage

### Requirements

PHP 8.1 and later.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/GIT_USER_ID/GIT_REPO_ID.git"
    }
  ],
  "require": {
    "GIT_USER_ID/GIT_REPO_ID": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new OpenAPI\Client\Api\AuthenticationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$access_token = 'access_token_example'; // string | Access token from integration creation

try {
    $result = $apiInstance->useAccessToken($access_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthenticationApi->useAccessToken: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://api.mywell.org/api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**useAccessToken**](docs/Api/AuthenticationApi.md#useaccesstoken) | **GET** /auth/access | Initial token exchange
*AuthenticationApi* | [**useRefreshToken**](docs/Api/AuthenticationApi.md#userefreshtoken) | **GET** /auth/refresh | Refresh token
*CampusesApi* | [**searchCampuses**](docs/Api/CampusesApi.md#searchcampuses) | **POST** /campus/search | Search campuses
*CustomersApi* | [**addPaymentMethod**](docs/Api/CustomersApi.md#addpaymentmethod) | **POST** /customer/{id}/paymentMethod | Add payment method
*CustomersApi* | [**createCustomer**](docs/Api/CustomersApi.md#createcustomer) | **POST** /customer | Create customer
*CustomersApi* | [**createCustomerAddress**](docs/Api/CustomersApi.md#createcustomeraddress) | **POST** /customer/{id}/address | Create customer address
*CustomersApi* | [**deleteCustomerAddress**](docs/Api/CustomersApi.md#deletecustomeraddress) | **DELETE** /customer/{id}/address/{id2} | Delete customer address
*CustomersApi* | [**deletePaymentMethod**](docs/Api/CustomersApi.md#deletepaymentmethod) | **DELETE** /customer/{id}/paymentMethod/{id2} | Delete payment method
*CustomersApi* | [**getCustomer**](docs/Api/CustomersApi.md#getcustomer) | **GET** /customer/{id} | Get customer
*CustomersApi* | [**getCustomerAddresses**](docs/Api/CustomersApi.md#getcustomeraddresses) | **GET** /customer/{id}/address | Get customer addresses
*CustomersApi* | [**getCustomerPaymentMethods**](docs/Api/CustomersApi.md#getcustomerpaymentmethods) | **GET** /customer/{id}/paymentMethod | Get customer payment methods
*CustomersApi* | [**searchCustomers**](docs/Api/CustomersApi.md#searchcustomers) | **POST** /customer/search | Search customers
*CustomersApi* | [**updateCustomer**](docs/Api/CustomersApi.md#updatecustomer) | **PUT** /customer/{id} | Update customer
*FundsApi* | [**searchFunds**](docs/Api/FundsApi.md#searchfunds) | **POST** /fund/search | Search funds
*SubscriptionsApi* | [**createSubscription**](docs/Api/SubscriptionsApi.md#createsubscription) | **POST** /subscription | Create subscription
*SubscriptionsApi* | [**getSubscription**](docs/Api/SubscriptionsApi.md#getsubscription) | **GET** /subscription/{id} | Get subscription
*SubscriptionsApi* | [**searchSubscriptions**](docs/Api/SubscriptionsApi.md#searchsubscriptions) | **POST** /subscription/search | Search subscriptions
*SubscriptionsApi* | [**updateSubscription**](docs/Api/SubscriptionsApi.md#updatesubscription) | **PUT** /subscription/{id} | Update subscription
*TransactionsApi* | [**createTransaction**](docs/Api/TransactionsApi.md#createtransaction) | **POST** /transaction | Create transaction
*TransactionsApi* | [**getTransaction**](docs/Api/TransactionsApi.md#gettransaction) | **GET** /transaction/{id} | Get transaction
*TransactionsApi* | [**refundTransaction**](docs/Api/TransactionsApi.md#refundtransaction) | **POST** /transaction/{id}/refund | Refund transaction
*TransactionsApi* | [**searchTransactions**](docs/Api/TransactionsApi.md#searchtransactions) | **POST** /transaction/search | Search transactions
*TransactionsApi* | [**voidTransaction**](docs/Api/TransactionsApi.md#voidtransaction) | **POST** /transaction/{id}/void | Void transaction

## Models

- [AddPaymentMethodRequest](docs/Model/AddPaymentMethodRequest.md)
- [Address](docs/Model/Address.md)
- [AddressListResponse](docs/Model/AddressListResponse.md)
- [AmountRange](docs/Model/AmountRange.md)
- [BillingAddress](docs/Model/BillingAddress.md)
- [Campus](docs/Model/Campus.md)
- [CampusSearchRequest](docs/Model/CampusSearchRequest.md)
- [CampusSearchResponse](docs/Model/CampusSearchResponse.md)
- [CreateAddressRequest](docs/Model/CreateAddressRequest.md)
- [CreateCustomerRequest](docs/Model/CreateCustomerRequest.md)
- [CreateSubscriptionRequest](docs/Model/CreateSubscriptionRequest.md)
- [CreateTransactionRequest](docs/Model/CreateTransactionRequest.md)
- [CustomerResponse](docs/Model/CustomerResponse.md)
- [CustomerSearchRequest](docs/Model/CustomerSearchRequest.md)
- [CustomerSearchResponse](docs/Model/CustomerSearchResponse.md)
- [DateRange](docs/Model/DateRange.md)
- [DeletePaymentMethod200Response](docs/Model/DeletePaymentMethod200Response.md)
- [DeletePaymentMethod200ResponseData](docs/Model/DeletePaymentMethod200ResponseData.md)
- [ErrorResponse](docs/Model/ErrorResponse.md)
- [Fund](docs/Model/Fund.md)
- [FundAllocation](docs/Model/FundAllocation.md)
- [FundSearchRequest](docs/Model/FundSearchRequest.md)
- [FundSearchResponse](docs/Model/FundSearchResponse.md)
- [Pagination](docs/Model/Pagination.md)
- [PaymentMethod](docs/Model/PaymentMethod.md)
- [PaymentMethodInput](docs/Model/PaymentMethodInput.md)
- [PaymentMethodListResponse](docs/Model/PaymentMethodListResponse.md)
- [SubscriptionResponse](docs/Model/SubscriptionResponse.md)
- [SubscriptionSearchRequest](docs/Model/SubscriptionSearchRequest.md)
- [SubscriptionSearchResponse](docs/Model/SubscriptionSearchResponse.md)
- [TokenResponse](docs/Model/TokenResponse.md)
- [TransactionResponse](docs/Model/TransactionResponse.md)
- [TransactionResponseCampus](docs/Model/TransactionResponseCampus.md)
- [TransactionResponseCustomer](docs/Model/TransactionResponseCustomer.md)
- [TransactionResponseFundsInner](docs/Model/TransactionResponseFundsInner.md)
- [TransactionSearchRequest](docs/Model/TransactionSearchRequest.md)
- [TransactionSearchResponse](docs/Model/TransactionSearchResponse.md)
- [UpdateAddressRequest](docs/Model/UpdateAddressRequest.md)
- [UpdateCustomerRequest](docs/Model/UpdateCustomerRequest.md)
- [UpdateSubscriptionRequest](docs/Model/UpdateSubscriptionRequest.md)

## Authorization
Endpoints do not require authorization.

## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `2.0.0`
    - Generator version: `7.17.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
