# OpenAPI\Client\AuthenticationApi

Token exchange endpoints

All URIs are relative to https://api.mywell.org/api/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**useAccessToken()**](AuthenticationApi.md#useAccessToken) | **GET** /auth/access | Initial token exchange |
| [**useRefreshToken()**](AuthenticationApi.md#useRefreshToken) | **GET** /auth/refresh | Refresh token |


## `useAccessToken()`

```php
useAccessToken($access_token): \OpenAPI\Client\Model\TokenResponse
```

Initial token exchange

One-time use endpoint for initial token exchange. Only works when integration is disabled. After successful use, the integration is enabled and this endpoint becomes unusable.  **Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\AuthenticationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$access_token = 'access_token_example'; // string | Access token from integration creation

try {
    $result = $apiInstance->useAccessToken($access_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthenticationApi->useAccessToken: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **access_token** | **string**| Access token from integration creation | |

### Return type

[**\OpenAPI\Client\Model\TokenResponse**](../Model/TokenResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `useRefreshToken()`

```php
useRefreshToken($refresh_token, $x_organization): \OpenAPI\Client\Model\TokenResponse
```

Refresh token

Get new tokens using refresh token

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\AuthenticationApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$refresh_token = 'refresh_token_example'; // string | Refresh token from previous token exchange
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization

try {
    $result = $apiInstance->useRefreshToken($refresh_token, $x_organization);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthenticationApi->useRefreshToken: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **refresh_token** | **string**| Refresh token from previous token exchange | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |

### Return type

[**\OpenAPI\Client\Model\TokenResponse**](../Model/TokenResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
