# OpenAPI\Client\CampusesApi

Campus search operations

All URIs are relative to https://api.mywell.org/api/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**searchCampuses()**](CampusesApi.md#searchCampuses) | **POST** /campus/search | Search campuses |


## `searchCampuses()`

```php
searchCampuses($x_authorization, $x_organization, $campus_search_request): \OpenAPI\Client\Model\CampusSearchResponse
```

Search campuses

Search for campuses with optional filters and pagination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CampusesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$campus_search_request = new \OpenAPI\Client\Model\CampusSearchRequest(); // \OpenAPI\Client\Model\CampusSearchRequest

try {
    $result = $apiInstance->searchCampuses($x_authorization, $x_organization, $campus_search_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CampusesApi->searchCampuses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **campus_search_request** | [**\OpenAPI\Client\Model\CampusSearchRequest**](../Model/CampusSearchRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\CampusSearchResponse**](../Model/CampusSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
