# OpenAPI\Client\CustomersApi

Customer management operations

All URIs are relative to https://api.mywell.org/api/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**addPaymentMethod()**](CustomersApi.md#addPaymentMethod) | **POST** /customer/{id}/paymentMethod | Add payment method |
| [**createCustomer()**](CustomersApi.md#createCustomer) | **POST** /customer | Create customer |
| [**createCustomerAddress()**](CustomersApi.md#createCustomerAddress) | **POST** /customer/{id}/address | Create customer address |
| [**deleteCustomerAddress()**](CustomersApi.md#deleteCustomerAddress) | **DELETE** /customer/{id}/address/{id2} | Delete customer address |
| [**deletePaymentMethod()**](CustomersApi.md#deletePaymentMethod) | **DELETE** /customer/{id}/paymentMethod/{id2} | Delete payment method |
| [**getCustomer()**](CustomersApi.md#getCustomer) | **GET** /customer/{id} | Get customer |
| [**getCustomerAddresses()**](CustomersApi.md#getCustomerAddresses) | **GET** /customer/{id}/address | Get customer addresses |
| [**getCustomerPaymentMethods()**](CustomersApi.md#getCustomerPaymentMethods) | **GET** /customer/{id}/paymentMethod | Get customer payment methods |
| [**searchCustomers()**](CustomersApi.md#searchCustomers) | **POST** /customer/search | Search customers |
| [**updateCustomer()**](CustomersApi.md#updateCustomer) | **PUT** /customer/{id} | Update customer |


## `addPaymentMethod()`

```php
addPaymentMethod($x_authorization, $x_organization, $id, $add_payment_method_request): \OpenAPI\Client\Model\PaymentMethod
```

Add payment method

Add a payment method to a customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID
$add_payment_method_request = new \OpenAPI\Client\Model\AddPaymentMethodRequest(); // \OpenAPI\Client\Model\AddPaymentMethodRequest

try {
    $result = $apiInstance->addPaymentMethod($x_authorization, $x_organization, $id, $add_payment_method_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->addPaymentMethod: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |
| **add_payment_method_request** | [**\OpenAPI\Client\Model\AddPaymentMethodRequest**](../Model/AddPaymentMethodRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\PaymentMethod**](../Model/PaymentMethod.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCustomer()`

```php
createCustomer($x_authorization, $x_organization, $create_customer_request): \OpenAPI\Client\Model\CustomerResponse
```

Create customer

Create a new customer with payment method

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$create_customer_request = {"kind":"DONATION","description":"New customer via Platform API","paymentMethod":{"token":"tok_visa_1234567890abcdef"},"firstName":"John","lastName":"Doe","email":"john.doe@example.com","phone":"555-123-4567","billingAddress":{"street1":"123 Main Street","street2":"Apt 4B","city":"New York","state":"NY","postalCode":"10001","country":"US"},"clientType":"WEB"}; // \OpenAPI\Client\Model\CreateCustomerRequest

try {
    $result = $apiInstance->createCustomer($x_authorization, $x_organization, $create_customer_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **create_customer_request** | [**\OpenAPI\Client\Model\CreateCustomerRequest**](../Model/CreateCustomerRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCustomerAddress()`

```php
createCustomerAddress($x_authorization, $x_organization, $id, $create_address_request): \OpenAPI\Client\Model\Address
```

Create customer address

Create a new address for a customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID
$create_address_request = new \OpenAPI\Client\Model\CreateAddressRequest(); // \OpenAPI\Client\Model\CreateAddressRequest

try {
    $result = $apiInstance->createCustomerAddress($x_authorization, $x_organization, $id, $create_address_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createCustomerAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |
| **create_address_request** | [**\OpenAPI\Client\Model\CreateAddressRequest**](../Model/CreateAddressRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\Address**](../Model/Address.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCustomerAddress()`

```php
deleteCustomerAddress($x_authorization, $x_organization, $id, $id2): \OpenAPI\Client\Model\DeletePaymentMethod200Response
```

Delete customer address

Delete an address from a customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID
$id2 = 'id2_example'; // string | Address ID

try {
    $result = $apiInstance->deleteCustomerAddress($x_authorization, $x_organization, $id, $id2);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->deleteCustomerAddress: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |
| **id2** | **string**| Address ID | |

### Return type

[**\OpenAPI\Client\Model\DeletePaymentMethod200Response**](../Model/DeletePaymentMethod200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deletePaymentMethod()`

```php
deletePaymentMethod($x_authorization, $x_organization, $id, $id2): \OpenAPI\Client\Model\DeletePaymentMethod200Response
```

Delete payment method

Delete a payment method from a customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID
$id2 = 'id2_example'; // string | Payment method ID

try {
    $result = $apiInstance->deletePaymentMethod($x_authorization, $x_organization, $id, $id2);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->deletePaymentMethod: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |
| **id2** | **string**| Payment method ID | |

### Return type

[**\OpenAPI\Client\Model\DeletePaymentMethod200Response**](../Model/DeletePaymentMethod200Response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomer()`

```php
getCustomer($x_authorization, $x_organization, $id): \OpenAPI\Client\Model\CustomerResponse
```

Get customer

Get customer by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID

try {
    $result = $apiInstance->getCustomer($x_authorization, $x_organization, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |

### Return type

[**\OpenAPI\Client\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerAddresses()`

```php
getCustomerAddresses($x_authorization, $x_organization, $id): \OpenAPI\Client\Model\AddressListResponse
```

Get customer addresses

Get all addresses for a customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID

try {
    $result = $apiInstance->getCustomerAddresses($x_authorization, $x_organization, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomerAddresses: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |

### Return type

[**\OpenAPI\Client\Model\AddressListResponse**](../Model/AddressListResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerPaymentMethods()`

```php
getCustomerPaymentMethods($x_authorization, $x_organization, $id): \OpenAPI\Client\Model\PaymentMethodListResponse
```

Get customer payment methods

Get all payment methods for a customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID

try {
    $result = $apiInstance->getCustomerPaymentMethods($x_authorization, $x_organization, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomerPaymentMethods: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |

### Return type

[**\OpenAPI\Client\Model\PaymentMethodListResponse**](../Model/PaymentMethodListResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchCustomers()`

```php
searchCustomers($x_authorization, $x_organization, $customer_search_request): \OpenAPI\Client\Model\CustomerSearchResponse
```

Search customers

Search for customers with optional filters and pagination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$customer_search_request = new \OpenAPI\Client\Model\CustomerSearchRequest(); // \OpenAPI\Client\Model\CustomerSearchRequest

try {
    $result = $apiInstance->searchCustomers($x_authorization, $x_organization, $customer_search_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->searchCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **customer_search_request** | [**\OpenAPI\Client\Model\CustomerSearchRequest**](../Model/CustomerSearchRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\CustomerSearchResponse**](../Model/CustomerSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCustomer()`

```php
updateCustomer($x_authorization, $x_organization, $id, $update_customer_request): \OpenAPI\Client\Model\CustomerResponse
```

Update customer

Update customer information

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Customer ID
$update_customer_request = new \OpenAPI\Client\Model\UpdateCustomerRequest(); // \OpenAPI\Client\Model\UpdateCustomerRequest

try {
    $result = $apiInstance->updateCustomer($x_authorization, $x_organization, $id, $update_customer_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->updateCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Customer ID | |
| **update_customer_request** | [**\OpenAPI\Client\Model\UpdateCustomerRequest**](../Model/UpdateCustomerRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
