# OpenAPI\Client\FundsApi

Fund search operations

All URIs are relative to https://api.mywell.org/api/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**searchFunds()**](FundsApi.md#searchFunds) | **POST** /fund/search | Search funds |


## `searchFunds()`

```php
searchFunds($x_authorization, $x_organization, $fund_search_request): \OpenAPI\Client\Model\FundSearchResponse
```

Search funds

Search for funds with optional filters and pagination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\FundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$fund_search_request = new \OpenAPI\Client\Model\FundSearchRequest(); // \OpenAPI\Client\Model\FundSearchRequest

try {
    $result = $apiInstance->searchFunds($x_authorization, $x_organization, $fund_search_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FundsApi->searchFunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **fund_search_request** | [**\OpenAPI\Client\Model\FundSearchRequest**](../Model/FundSearchRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\FundSearchResponse**](../Model/FundSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
