# OpenAPI\Client\SubscriptionsApi

Subscription management

All URIs are relative to https://api.mywell.org/api/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createSubscription()**](SubscriptionsApi.md#createSubscription) | **POST** /subscription | Create subscription |
| [**getSubscription()**](SubscriptionsApi.md#getSubscription) | **GET** /subscription/{id} | Get subscription |
| [**searchSubscriptions()**](SubscriptionsApi.md#searchSubscriptions) | **POST** /subscription/search | Search subscriptions |
| [**updateSubscription()**](SubscriptionsApi.md#updateSubscription) | **PUT** /subscription/{id} | Update subscription |


## `createSubscription()`

```php
createSubscription($x_authorization, $x_organization, $create_subscription_request): \OpenAPI\Client\Model\SubscriptionResponse
```

Create subscription

Create a new subscription

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\SubscriptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$create_subscription_request = {"amount":2500,"frequency":"MONTHLY","startDate":"2024-01-15","customerId":"cmfl3x8be0001bkh9e2geb994","paymentMethodId":"cmfmnfgiq000hmgyucovh836z","campusId":"cmfl3x8be0001bkh9e2geb994","description":"Monthly recurring donation","fundId":"ck9u2gs9s01xh0746q15yeooe"}; // \OpenAPI\Client\Model\CreateSubscriptionRequest

try {
    $result = $apiInstance->createSubscription($x_authorization, $x_organization, $create_subscription_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SubscriptionsApi->createSubscription: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **create_subscription_request** | [**\OpenAPI\Client\Model\CreateSubscriptionRequest**](../Model/CreateSubscriptionRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\SubscriptionResponse**](../Model/SubscriptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSubscription()`

```php
getSubscription($x_authorization, $x_organization, $id): \OpenAPI\Client\Model\SubscriptionResponse
```

Get subscription

Get subscription by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\SubscriptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Subscription ID

try {
    $result = $apiInstance->getSubscription($x_authorization, $x_organization, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SubscriptionsApi->getSubscription: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Subscription ID | |

### Return type

[**\OpenAPI\Client\Model\SubscriptionResponse**](../Model/SubscriptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchSubscriptions()`

```php
searchSubscriptions($x_authorization, $x_organization, $subscription_search_request): \OpenAPI\Client\Model\SubscriptionSearchResponse
```

Search subscriptions

Search for subscriptions with optional filters and pagination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\SubscriptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$subscription_search_request = new \OpenAPI\Client\Model\SubscriptionSearchRequest(); // \OpenAPI\Client\Model\SubscriptionSearchRequest

try {
    $result = $apiInstance->searchSubscriptions($x_authorization, $x_organization, $subscription_search_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SubscriptionsApi->searchSubscriptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **subscription_search_request** | [**\OpenAPI\Client\Model\SubscriptionSearchRequest**](../Model/SubscriptionSearchRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\SubscriptionSearchResponse**](../Model/SubscriptionSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSubscription()`

```php
updateSubscription($x_authorization, $x_organization, $id, $update_subscription_request): \OpenAPI\Client\Model\SubscriptionResponse
```

Update subscription

Update subscription details

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\SubscriptionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Subscription ID
$update_subscription_request = new \OpenAPI\Client\Model\UpdateSubscriptionRequest(); // \OpenAPI\Client\Model\UpdateSubscriptionRequest

try {
    $result = $apiInstance->updateSubscription($x_authorization, $x_organization, $id, $update_subscription_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SubscriptionsApi->updateSubscription: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Subscription ID | |
| **update_subscription_request** | [**\OpenAPI\Client\Model\UpdateSubscriptionRequest**](../Model/UpdateSubscriptionRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\SubscriptionResponse**](../Model/SubscriptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
