# OpenAPI\Client\TransactionsApi

Transaction operations

All URIs are relative to https://api.mywell.org/api/v2, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**createTransaction()**](TransactionsApi.md#createTransaction) | **POST** /transaction | Create transaction |
| [**getTransaction()**](TransactionsApi.md#getTransaction) | **GET** /transaction/{id} | Get transaction |
| [**refundTransaction()**](TransactionsApi.md#refundTransaction) | **POST** /transaction/{id}/refund | Refund transaction |
| [**searchTransactions()**](TransactionsApi.md#searchTransactions) | **POST** /transaction/search | Search transactions |
| [**voidTransaction()**](TransactionsApi.md#voidTransaction) | **POST** /transaction/{id}/void | Void transaction |


## `createTransaction()`

```php
createTransaction($x_authorization, $x_organization, $create_transaction_request): \OpenAPI\Client\Model\TransactionResponse
```

Create transaction

Create a new transaction

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$create_transaction_request = {"amount":5000,"customerId":"cmfl3x8be0001bkh9e2geb994","paymentMethodId":"d34n8ef0i47dk6gs9gog","campusId":"cmfl3x8be0001bkh9e2geb994","fundId":"fund123abc","description":"One-time donation","feesCovered":true}; // \OpenAPI\Client\Model\CreateTransactionRequest

try {
    $result = $apiInstance->createTransaction($x_authorization, $x_organization, $create_transaction_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->createTransaction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **create_transaction_request** | [**\OpenAPI\Client\Model\CreateTransactionRequest**](../Model/CreateTransactionRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\TransactionResponse**](../Model/TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTransaction()`

```php
getTransaction($x_authorization, $x_organization, $id): \OpenAPI\Client\Model\TransactionResponse
```

Get transaction

Get transaction by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Transaction ID

try {
    $result = $apiInstance->getTransaction($x_authorization, $x_organization, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->getTransaction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Transaction ID | |

### Return type

[**\OpenAPI\Client\Model\TransactionResponse**](../Model/TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `refundTransaction()`

```php
refundTransaction($x_authorization, $x_organization, $id, $body): \OpenAPI\Client\Model\TransactionResponse
```

Refund transaction

Refund a transaction (full refund only)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Transaction ID
$body = array('key' => new \stdClass); // object

try {
    $result = $apiInstance->refundTransaction($x_authorization, $x_organization, $id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->refundTransaction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Transaction ID | |
| **body** | **object**|  | [optional] |

### Return type

[**\OpenAPI\Client\Model\TransactionResponse**](../Model/TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchTransactions()`

```php
searchTransactions($x_authorization, $x_organization, $transaction_search_request): \OpenAPI\Client\Model\TransactionSearchResponse
```

Search transactions

Search for transactions with optional filters and pagination

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$transaction_search_request = new \OpenAPI\Client\Model\TransactionSearchRequest(); // \OpenAPI\Client\Model\TransactionSearchRequest

try {
    $result = $apiInstance->searchTransactions($x_authorization, $x_organization, $transaction_search_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->searchTransactions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **transaction_search_request** | [**\OpenAPI\Client\Model\TransactionSearchRequest**](../Model/TransactionSearchRequest.md)|  | |

### Return type

[**\OpenAPI\Client\Model\TransactionSearchResponse**](../Model/TransactionSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `voidTransaction()`

```php
voidTransaction($x_authorization, $x_organization, $id): \OpenAPI\Client\Model\TransactionResponse
```

Void transaction

Void a transaction that hasn't been settled

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new OpenAPI\Client\Api\TransactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$x_authorization = Bearer YOUR_PLATFORM_API_ACCESS_TOKEN; // string | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
$x_organization = cmfl3x8be0001bkh9e2geb994; // string | Organization ID that must match the integration's organization
$id = 'id_example'; // string | Transaction ID

try {
    $result = $apiInstance->voidTransaction($x_authorization, $x_organization, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TransactionsApi->voidTransaction: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **x_authorization** | **string**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | |
| **x_organization** | **string**| Organization ID that must match the integration&#39;s organization | |
| **id** | **string**| Transaction ID | |

### Return type

[**\OpenAPI\Client\Model\TransactionResponse**](../Model/TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
