<?php
/**
 * CustomersApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * MyWell Platform API
 *
 * # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes
 *
 * The version of the OpenAPI document: 2.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * CustomersApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addPaymentMethod' => [
            'application/json',
        ],
        'createCustomer' => [
            'application/json',
        ],
        'createCustomerAddress' => [
            'application/json',
        ],
        'deleteCustomerAddress' => [
            'application/json',
        ],
        'deletePaymentMethod' => [
            'application/json',
        ],
        'getCustomer' => [
            'application/json',
        ],
        'getCustomerAddresses' => [
            'application/json',
        ],
        'getCustomerPaymentMethods' => [
            'application/json',
        ],
        'searchCustomers' => [
            'application/json',
        ],
        'updateCustomer' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addPaymentMethod
     *
     * Add payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\AddPaymentMethodRequest $add_payment_method_request add_payment_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPaymentMethod'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\PaymentMethod|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function addPaymentMethod($x_authorization, $x_organization, $id, $add_payment_method_request, string $contentType = self::contentTypes['addPaymentMethod'][0])
    {
        list($response) = $this->addPaymentMethodWithHttpInfo($x_authorization, $x_organization, $id, $add_payment_method_request, $contentType);
        return $response;
    }

    /**
     * Operation addPaymentMethodWithHttpInfo
     *
     * Add payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\AddPaymentMethodRequest $add_payment_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPaymentMethod'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\PaymentMethod|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addPaymentMethodWithHttpInfo($x_authorization, $x_organization, $id, $add_payment_method_request, string $contentType = self::contentTypes['addPaymentMethod'][0])
    {
        $request = $this->addPaymentMethodRequest($x_authorization, $x_organization, $id, $add_payment_method_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\PaymentMethod',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\PaymentMethod',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\PaymentMethod',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation addPaymentMethodAsync
     *
     * Add payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\AddPaymentMethodRequest $add_payment_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPaymentMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addPaymentMethodAsync($x_authorization, $x_organization, $id, $add_payment_method_request, string $contentType = self::contentTypes['addPaymentMethod'][0])
    {
        return $this->addPaymentMethodAsyncWithHttpInfo($x_authorization, $x_organization, $id, $add_payment_method_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addPaymentMethodAsyncWithHttpInfo
     *
     * Add payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\AddPaymentMethodRequest $add_payment_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPaymentMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addPaymentMethodAsyncWithHttpInfo($x_authorization, $x_organization, $id, $add_payment_method_request, string $contentType = self::contentTypes['addPaymentMethod'][0])
    {
        $returnType = '\OpenAPI\Client\Model\PaymentMethod';
        $request = $this->addPaymentMethodRequest($x_authorization, $x_organization, $id, $add_payment_method_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addPaymentMethod'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\AddPaymentMethodRequest $add_payment_method_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addPaymentMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addPaymentMethodRequest($x_authorization, $x_organization, $id, $add_payment_method_request, string $contentType = self::contentTypes['addPaymentMethod'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling addPaymentMethod'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling addPaymentMethod'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling addPaymentMethod'
            );
        }

        // verify the required parameter 'add_payment_method_request' is set
        if ($add_payment_method_request === null || (is_array($add_payment_method_request) && count($add_payment_method_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $add_payment_method_request when calling addPaymentMethod'
            );
        }


        $resourcePath = '/customer/{id}/paymentMethod';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($add_payment_method_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($add_payment_method_request));
            } else {
                $httpBody = $add_payment_method_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCustomer
     *
     * Create customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateCustomerRequest $create_customer_request create_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomer'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\CustomerResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function createCustomer($x_authorization, $x_organization, $create_customer_request, string $contentType = self::contentTypes['createCustomer'][0])
    {
        list($response) = $this->createCustomerWithHttpInfo($x_authorization, $x_organization, $create_customer_request, $contentType);
        return $response;
    }

    /**
     * Operation createCustomerWithHttpInfo
     *
     * Create customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateCustomerRequest $create_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomer'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\CustomerResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomerWithHttpInfo($x_authorization, $x_organization, $create_customer_request, string $contentType = self::contentTypes['createCustomer'][0])
    {
        $request = $this->createCustomerRequest($x_authorization, $x_organization, $create_customer_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\CustomerResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\CustomerResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\CustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createCustomerAsync
     *
     * Create customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateCustomerRequest $create_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAsync($x_authorization, $x_organization, $create_customer_request, string $contentType = self::contentTypes['createCustomer'][0])
    {
        return $this->createCustomerAsyncWithHttpInfo($x_authorization, $x_organization, $create_customer_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomerAsyncWithHttpInfo
     *
     * Create customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateCustomerRequest $create_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAsyncWithHttpInfo($x_authorization, $x_organization, $create_customer_request, string $contentType = self::contentTypes['createCustomer'][0])
    {
        $returnType = '\OpenAPI\Client\Model\CustomerResponse';
        $request = $this->createCustomerRequest($x_authorization, $x_organization, $create_customer_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomer'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateCustomerRequest $create_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCustomerRequest($x_authorization, $x_organization, $create_customer_request, string $contentType = self::contentTypes['createCustomer'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling createCustomer'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling createCustomer'
            );
        }

        // verify the required parameter 'create_customer_request' is set
        if ($create_customer_request === null || (is_array($create_customer_request) && count($create_customer_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_customer_request when calling createCustomer'
            );
        }


        $resourcePath = '/customer';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_customer_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_customer_request));
            } else {
                $httpBody = $create_customer_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCustomerAddress
     *
     * Create customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\CreateAddressRequest $create_address_request create_address_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerAddress'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\Address|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function createCustomerAddress($x_authorization, $x_organization, $id, $create_address_request, string $contentType = self::contentTypes['createCustomerAddress'][0])
    {
        list($response) = $this->createCustomerAddressWithHttpInfo($x_authorization, $x_organization, $id, $create_address_request, $contentType);
        return $response;
    }

    /**
     * Operation createCustomerAddressWithHttpInfo
     *
     * Create customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\CreateAddressRequest $create_address_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerAddress'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\Address|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomerAddressWithHttpInfo($x_authorization, $x_organization, $id, $create_address_request, string $contentType = self::contentTypes['createCustomerAddress'][0])
    {
        $request = $this->createCustomerAddressRequest($x_authorization, $x_organization, $id, $create_address_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\Address',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\Address',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\Address',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createCustomerAddressAsync
     *
     * Create customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\CreateAddressRequest $create_address_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAddressAsync($x_authorization, $x_organization, $id, $create_address_request, string $contentType = self::contentTypes['createCustomerAddress'][0])
    {
        return $this->createCustomerAddressAsyncWithHttpInfo($x_authorization, $x_organization, $id, $create_address_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCustomerAddressAsyncWithHttpInfo
     *
     * Create customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\CreateAddressRequest $create_address_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomerAddressAsyncWithHttpInfo($x_authorization, $x_organization, $id, $create_address_request, string $contentType = self::contentTypes['createCustomerAddress'][0])
    {
        $returnType = '\OpenAPI\Client\Model\Address';
        $request = $this->createCustomerAddressRequest($x_authorization, $x_organization, $id, $create_address_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCustomerAddress'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\CreateAddressRequest $create_address_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCustomerAddressRequest($x_authorization, $x_organization, $id, $create_address_request, string $contentType = self::contentTypes['createCustomerAddress'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling createCustomerAddress'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling createCustomerAddress'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling createCustomerAddress'
            );
        }

        // verify the required parameter 'create_address_request' is set
        if ($create_address_request === null || (is_array($create_address_request) && count($create_address_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_address_request when calling createCustomerAddress'
            );
        }


        $resourcePath = '/customer/{id}/address';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_address_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_address_request));
            } else {
                $httpBody = $create_address_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCustomerAddress
     *
     * Delete customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Address ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerAddress'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DeletePaymentMethod200Response|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function deleteCustomerAddress($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deleteCustomerAddress'][0])
    {
        list($response) = $this->deleteCustomerAddressWithHttpInfo($x_authorization, $x_organization, $id, $id2, $contentType);
        return $response;
    }

    /**
     * Operation deleteCustomerAddressWithHttpInfo
     *
     * Delete customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Address ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerAddress'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DeletePaymentMethod200Response|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomerAddressWithHttpInfo($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deleteCustomerAddress'][0])
    {
        $request = $this->deleteCustomerAddressRequest($x_authorization, $x_organization, $id, $id2, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DeletePaymentMethod200Response',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DeletePaymentMethod200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DeletePaymentMethod200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteCustomerAddressAsync
     *
     * Delete customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Address ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomerAddressAsync($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deleteCustomerAddress'][0])
    {
        return $this->deleteCustomerAddressAsyncWithHttpInfo($x_authorization, $x_organization, $id, $id2, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCustomerAddressAsyncWithHttpInfo
     *
     * Delete customer address
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Address ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCustomerAddressAsyncWithHttpInfo($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deleteCustomerAddress'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DeletePaymentMethod200Response';
        $request = $this->deleteCustomerAddressRequest($x_authorization, $x_organization, $id, $id2, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCustomerAddress'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Address ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCustomerAddress'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCustomerAddressRequest($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deleteCustomerAddress'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling deleteCustomerAddress'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling deleteCustomerAddress'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteCustomerAddress'
            );
        }

        // verify the required parameter 'id2' is set
        if ($id2 === null || (is_array($id2) && count($id2) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id2 when calling deleteCustomerAddress'
            );
        }


        $resourcePath = '/customer/{id}/address/{id2}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($id2 !== null) {
            $resourcePath = str_replace(
                '{' . 'id2' . '}',
                ObjectSerializer::toPathValue($id2),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePaymentMethod
     *
     * Delete payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Payment method ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentMethod'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\DeletePaymentMethod200Response|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function deletePaymentMethod($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deletePaymentMethod'][0])
    {
        list($response) = $this->deletePaymentMethodWithHttpInfo($x_authorization, $x_organization, $id, $id2, $contentType);
        return $response;
    }

    /**
     * Operation deletePaymentMethodWithHttpInfo
     *
     * Delete payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Payment method ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentMethod'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\DeletePaymentMethod200Response|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePaymentMethodWithHttpInfo($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deletePaymentMethod'][0])
    {
        $request = $this->deletePaymentMethodRequest($x_authorization, $x_organization, $id, $id2, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\DeletePaymentMethod200Response',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\DeletePaymentMethod200Response',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\DeletePaymentMethod200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deletePaymentMethodAsync
     *
     * Delete payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Payment method ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentMethodAsync($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deletePaymentMethod'][0])
    {
        return $this->deletePaymentMethodAsyncWithHttpInfo($x_authorization, $x_organization, $id, $id2, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePaymentMethodAsyncWithHttpInfo
     *
     * Delete payment method
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Payment method ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deletePaymentMethodAsyncWithHttpInfo($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deletePaymentMethod'][0])
    {
        $returnType = '\OpenAPI\Client\Model\DeletePaymentMethod200Response';
        $request = $this->deletePaymentMethodRequest($x_authorization, $x_organization, $id, $id2, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePaymentMethod'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $id2 Payment method ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePaymentMethod'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deletePaymentMethodRequest($x_authorization, $x_organization, $id, $id2, string $contentType = self::contentTypes['deletePaymentMethod'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling deletePaymentMethod'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling deletePaymentMethod'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deletePaymentMethod'
            );
        }

        // verify the required parameter 'id2' is set
        if ($id2 === null || (is_array($id2) && count($id2) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id2 when calling deletePaymentMethod'
            );
        }


        $resourcePath = '/customer/{id}/paymentMethod/{id2}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // path params
        if ($id2 !== null) {
            $resourcePath = str_replace(
                '{' . 'id2' . '}',
                ObjectSerializer::toPathValue($id2),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomer
     *
     * Get customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomer'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\CustomerResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function getCustomer($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomer'][0])
    {
        list($response) = $this->getCustomerWithHttpInfo($x_authorization, $x_organization, $id, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerWithHttpInfo
     *
     * Get customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomer'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\CustomerResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomer'][0])
    {
        $request = $this->getCustomerRequest($x_authorization, $x_organization, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\CustomerResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\CustomerResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\CustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomerAsync
     *
     * Get customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerAsync($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomer'][0])
    {
        return $this->getCustomerAsyncWithHttpInfo($x_authorization, $x_organization, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerAsyncWithHttpInfo
     *
     * Get customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerAsyncWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomer'][0])
    {
        $returnType = '\OpenAPI\Client\Model\CustomerResponse';
        $request = $this->getCustomerRequest($x_authorization, $x_organization, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomer'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerRequest($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomer'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling getCustomer'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling getCustomer'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getCustomer'
            );
        }


        $resourcePath = '/customer/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomerAddresses
     *
     * Get customer addresses
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\AddressListResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function getCustomerAddresses($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerAddresses'][0])
    {
        list($response) = $this->getCustomerAddressesWithHttpInfo($x_authorization, $x_organization, $id, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerAddressesWithHttpInfo
     *
     * Get customer addresses
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\AddressListResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerAddressesWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerAddresses'][0])
    {
        $request = $this->getCustomerAddressesRequest($x_authorization, $x_organization, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\AddressListResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\AddressListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\AddressListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomerAddressesAsync
     *
     * Get customer addresses
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerAddressesAsync($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerAddresses'][0])
    {
        return $this->getCustomerAddressesAsyncWithHttpInfo($x_authorization, $x_organization, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerAddressesAsyncWithHttpInfo
     *
     * Get customer addresses
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerAddressesAsyncWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerAddresses'][0])
    {
        $returnType = '\OpenAPI\Client\Model\AddressListResponse';
        $request = $this->getCustomerAddressesRequest($x_authorization, $x_organization, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomerAddresses'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerAddresses'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerAddressesRequest($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerAddresses'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling getCustomerAddresses'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling getCustomerAddresses'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getCustomerAddresses'
            );
        }


        $resourcePath = '/customer/{id}/address';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCustomerPaymentMethods
     *
     * Get customer payment methods
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerPaymentMethods'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\PaymentMethodListResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function getCustomerPaymentMethods($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerPaymentMethods'][0])
    {
        list($response) = $this->getCustomerPaymentMethodsWithHttpInfo($x_authorization, $x_organization, $id, $contentType);
        return $response;
    }

    /**
     * Operation getCustomerPaymentMethodsWithHttpInfo
     *
     * Get customer payment methods
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerPaymentMethods'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\PaymentMethodListResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCustomerPaymentMethodsWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerPaymentMethods'][0])
    {
        $request = $this->getCustomerPaymentMethodsRequest($x_authorization, $x_organization, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\PaymentMethodListResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\PaymentMethodListResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\PaymentMethodListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getCustomerPaymentMethodsAsync
     *
     * Get customer payment methods
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerPaymentMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerPaymentMethodsAsync($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerPaymentMethods'][0])
    {
        return $this->getCustomerPaymentMethodsAsyncWithHttpInfo($x_authorization, $x_organization, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCustomerPaymentMethodsAsyncWithHttpInfo
     *
     * Get customer payment methods
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerPaymentMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomerPaymentMethodsAsyncWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerPaymentMethods'][0])
    {
        $returnType = '\OpenAPI\Client\Model\PaymentMethodListResponse';
        $request = $this->getCustomerPaymentMethodsRequest($x_authorization, $x_organization, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCustomerPaymentMethods'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCustomerPaymentMethods'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCustomerPaymentMethodsRequest($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getCustomerPaymentMethods'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling getCustomerPaymentMethods'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling getCustomerPaymentMethods'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getCustomerPaymentMethods'
            );
        }


        $resourcePath = '/customer/{id}/paymentMethod';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchCustomers
     *
     * Search customers
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CustomerSearchRequest $customer_search_request customer_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCustomers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\CustomerSearchResponse
     */
    public function searchCustomers($x_authorization, $x_organization, $customer_search_request, string $contentType = self::contentTypes['searchCustomers'][0])
    {
        list($response) = $this->searchCustomersWithHttpInfo($x_authorization, $x_organization, $customer_search_request, $contentType);
        return $response;
    }

    /**
     * Operation searchCustomersWithHttpInfo
     *
     * Search customers
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CustomerSearchRequest $customer_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCustomers'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\CustomerSearchResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchCustomersWithHttpInfo($x_authorization, $x_organization, $customer_search_request, string $contentType = self::contentTypes['searchCustomers'][0])
    {
        $request = $this->searchCustomersRequest($x_authorization, $x_organization, $customer_search_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\CustomerSearchResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\CustomerSearchResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\CustomerSearchResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation searchCustomersAsync
     *
     * Search customers
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CustomerSearchRequest $customer_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchCustomersAsync($x_authorization, $x_organization, $customer_search_request, string $contentType = self::contentTypes['searchCustomers'][0])
    {
        return $this->searchCustomersAsyncWithHttpInfo($x_authorization, $x_organization, $customer_search_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchCustomersAsyncWithHttpInfo
     *
     * Search customers
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CustomerSearchRequest $customer_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchCustomersAsyncWithHttpInfo($x_authorization, $x_organization, $customer_search_request, string $contentType = self::contentTypes['searchCustomers'][0])
    {
        $returnType = '\OpenAPI\Client\Model\CustomerSearchResponse';
        $request = $this->searchCustomersRequest($x_authorization, $x_organization, $customer_search_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchCustomers'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CustomerSearchRequest $customer_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchCustomers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchCustomersRequest($x_authorization, $x_organization, $customer_search_request, string $contentType = self::contentTypes['searchCustomers'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling searchCustomers'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling searchCustomers'
            );
        }

        // verify the required parameter 'customer_search_request' is set
        if ($customer_search_request === null || (is_array($customer_search_request) && count($customer_search_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $customer_search_request when calling searchCustomers'
            );
        }


        $resourcePath = '/customer/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($customer_search_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($customer_search_request));
            } else {
                $httpBody = $customer_search_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCustomer
     *
     * Update customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\UpdateCustomerRequest $update_customer_request update_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomer'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\CustomerResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function updateCustomer($x_authorization, $x_organization, $id, $update_customer_request, string $contentType = self::contentTypes['updateCustomer'][0])
    {
        list($response) = $this->updateCustomerWithHttpInfo($x_authorization, $x_organization, $id, $update_customer_request, $contentType);
        return $response;
    }

    /**
     * Operation updateCustomerWithHttpInfo
     *
     * Update customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\UpdateCustomerRequest $update_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomer'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\CustomerResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomerWithHttpInfo($x_authorization, $x_organization, $id, $update_customer_request, string $contentType = self::contentTypes['updateCustomer'][0])
    {
        $request = $this->updateCustomerRequest($x_authorization, $x_organization, $id, $update_customer_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\CustomerResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\CustomerResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\CustomerResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateCustomerAsync
     *
     * Update customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\UpdateCustomerRequest $update_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomerAsync($x_authorization, $x_organization, $id, $update_customer_request, string $contentType = self::contentTypes['updateCustomer'][0])
    {
        return $this->updateCustomerAsyncWithHttpInfo($x_authorization, $x_organization, $id, $update_customer_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCustomerAsyncWithHttpInfo
     *
     * Update customer
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\UpdateCustomerRequest $update_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomerAsyncWithHttpInfo($x_authorization, $x_organization, $id, $update_customer_request, string $contentType = self::contentTypes['updateCustomer'][0])
    {
        $returnType = '\OpenAPI\Client\Model\CustomerResponse';
        $request = $this->updateCustomerRequest($x_authorization, $x_organization, $id, $update_customer_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCustomer'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Customer ID (required)
     * @param  \OpenAPI\Client\Model\UpdateCustomerRequest $update_customer_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCustomer'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateCustomerRequest($x_authorization, $x_organization, $id, $update_customer_request, string $contentType = self::contentTypes['updateCustomer'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling updateCustomer'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling updateCustomer'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateCustomer'
            );
        }

        // verify the required parameter 'update_customer_request' is set
        if ($update_customer_request === null || (is_array($update_customer_request) && count($update_customer_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_customer_request when calling updateCustomer'
            );
        }


        $resourcePath = '/customer/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_customer_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_customer_request));
            } else {
                $httpBody = $update_customer_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
