<?php
/**
 * SubscriptionsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * MyWell Platform API
 *
 * # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes
 *
 * The version of the OpenAPI document: 2.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * SubscriptionsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SubscriptionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createSubscription' => [
            'application/json',
        ],
        'getSubscription' => [
            'application/json',
        ],
        'searchSubscriptions' => [
            'application/json',
        ],
        'updateSubscription' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createSubscription
     *
     * Create subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateSubscriptionRequest $create_subscription_request create_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SubscriptionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function createSubscription($x_authorization, $x_organization, $create_subscription_request, string $contentType = self::contentTypes['createSubscription'][0])
    {
        list($response) = $this->createSubscriptionWithHttpInfo($x_authorization, $x_organization, $create_subscription_request, $contentType);
        return $response;
    }

    /**
     * Operation createSubscriptionWithHttpInfo
     *
     * Create subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateSubscriptionRequest $create_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SubscriptionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSubscriptionWithHttpInfo($x_authorization, $x_organization, $create_subscription_request, string $contentType = self::contentTypes['createSubscription'][0])
    {
        $request = $this->createSubscriptionRequest($x_authorization, $x_organization, $create_subscription_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SubscriptionResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SubscriptionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SubscriptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createSubscriptionAsync
     *
     * Create subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateSubscriptionRequest $create_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSubscriptionAsync($x_authorization, $x_organization, $create_subscription_request, string $contentType = self::contentTypes['createSubscription'][0])
    {
        return $this->createSubscriptionAsyncWithHttpInfo($x_authorization, $x_organization, $create_subscription_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSubscriptionAsyncWithHttpInfo
     *
     * Create subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateSubscriptionRequest $create_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSubscriptionAsyncWithHttpInfo($x_authorization, $x_organization, $create_subscription_request, string $contentType = self::contentTypes['createSubscription'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SubscriptionResponse';
        $request = $this->createSubscriptionRequest($x_authorization, $x_organization, $create_subscription_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSubscription'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateSubscriptionRequest $create_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSubscriptionRequest($x_authorization, $x_organization, $create_subscription_request, string $contentType = self::contentTypes['createSubscription'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling createSubscription'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling createSubscription'
            );
        }

        // verify the required parameter 'create_subscription_request' is set
        if ($create_subscription_request === null || (is_array($create_subscription_request) && count($create_subscription_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_subscription_request when calling createSubscription'
            );
        }


        $resourcePath = '/subscription';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_subscription_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_subscription_request));
            } else {
                $httpBody = $create_subscription_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSubscription
     *
     * Get subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SubscriptionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function getSubscription($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        list($response) = $this->getSubscriptionWithHttpInfo($x_authorization, $x_organization, $id, $contentType);
        return $response;
    }

    /**
     * Operation getSubscriptionWithHttpInfo
     *
     * Get subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SubscriptionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSubscriptionWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        $request = $this->getSubscriptionRequest($x_authorization, $x_organization, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SubscriptionResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SubscriptionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SubscriptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSubscriptionAsync
     *
     * Get subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionAsync($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        return $this->getSubscriptionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSubscriptionAsyncWithHttpInfo
     *
     * Get subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSubscriptionAsyncWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getSubscription'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SubscriptionResponse';
        $request = $this->getSubscriptionRequest($x_authorization, $x_organization, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSubscription'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSubscriptionRequest($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getSubscription'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling getSubscription'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling getSubscription'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getSubscription'
            );
        }


        $resourcePath = '/subscription/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchSubscriptions
     *
     * Search subscriptions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\SubscriptionSearchRequest $subscription_search_request subscription_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchSubscriptions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SubscriptionSearchResponse
     */
    public function searchSubscriptions($x_authorization, $x_organization, $subscription_search_request, string $contentType = self::contentTypes['searchSubscriptions'][0])
    {
        list($response) = $this->searchSubscriptionsWithHttpInfo($x_authorization, $x_organization, $subscription_search_request, $contentType);
        return $response;
    }

    /**
     * Operation searchSubscriptionsWithHttpInfo
     *
     * Search subscriptions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\SubscriptionSearchRequest $subscription_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchSubscriptions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SubscriptionSearchResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchSubscriptionsWithHttpInfo($x_authorization, $x_organization, $subscription_search_request, string $contentType = self::contentTypes['searchSubscriptions'][0])
    {
        $request = $this->searchSubscriptionsRequest($x_authorization, $x_organization, $subscription_search_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SubscriptionSearchResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SubscriptionSearchResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SubscriptionSearchResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation searchSubscriptionsAsync
     *
     * Search subscriptions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\SubscriptionSearchRequest $subscription_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchSubscriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchSubscriptionsAsync($x_authorization, $x_organization, $subscription_search_request, string $contentType = self::contentTypes['searchSubscriptions'][0])
    {
        return $this->searchSubscriptionsAsyncWithHttpInfo($x_authorization, $x_organization, $subscription_search_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchSubscriptionsAsyncWithHttpInfo
     *
     * Search subscriptions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\SubscriptionSearchRequest $subscription_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchSubscriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchSubscriptionsAsyncWithHttpInfo($x_authorization, $x_organization, $subscription_search_request, string $contentType = self::contentTypes['searchSubscriptions'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SubscriptionSearchResponse';
        $request = $this->searchSubscriptionsRequest($x_authorization, $x_organization, $subscription_search_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchSubscriptions'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\SubscriptionSearchRequest $subscription_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchSubscriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchSubscriptionsRequest($x_authorization, $x_organization, $subscription_search_request, string $contentType = self::contentTypes['searchSubscriptions'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling searchSubscriptions'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling searchSubscriptions'
            );
        }

        // verify the required parameter 'subscription_search_request' is set
        if ($subscription_search_request === null || (is_array($subscription_search_request) && count($subscription_search_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscription_search_request when calling searchSubscriptions'
            );
        }


        $resourcePath = '/subscription/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($subscription_search_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($subscription_search_request));
            } else {
                $httpBody = $subscription_search_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSubscription
     *
     * Update subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscriptionRequest $update_subscription_request update_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\SubscriptionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function updateSubscription($x_authorization, $x_organization, $id, $update_subscription_request, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        list($response) = $this->updateSubscriptionWithHttpInfo($x_authorization, $x_organization, $id, $update_subscription_request, $contentType);
        return $response;
    }

    /**
     * Operation updateSubscriptionWithHttpInfo
     *
     * Update subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscriptionRequest $update_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\SubscriptionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSubscriptionWithHttpInfo($x_authorization, $x_organization, $id, $update_subscription_request, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        $request = $this->updateSubscriptionRequest($x_authorization, $x_organization, $id, $update_subscription_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\SubscriptionResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\SubscriptionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\SubscriptionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateSubscriptionAsync
     *
     * Update subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscriptionRequest $update_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSubscriptionAsync($x_authorization, $x_organization, $id, $update_subscription_request, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        return $this->updateSubscriptionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $update_subscription_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSubscriptionAsyncWithHttpInfo
     *
     * Update subscription
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscriptionRequest $update_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSubscriptionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $update_subscription_request, string $contentType = self::contentTypes['updateSubscription'][0])
    {
        $returnType = '\OpenAPI\Client\Model\SubscriptionResponse';
        $request = $this->updateSubscriptionRequest($x_authorization, $x_organization, $id, $update_subscription_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSubscription'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Subscription ID (required)
     * @param  \OpenAPI\Client\Model\UpdateSubscriptionRequest $update_subscription_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSubscription'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSubscriptionRequest($x_authorization, $x_organization, $id, $update_subscription_request, string $contentType = self::contentTypes['updateSubscription'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling updateSubscription'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling updateSubscription'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateSubscription'
            );
        }

        // verify the required parameter 'update_subscription_request' is set
        if ($update_subscription_request === null || (is_array($update_subscription_request) && count($update_subscription_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $update_subscription_request when calling updateSubscription'
            );
        }


        $resourcePath = '/subscription/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_subscription_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_subscription_request));
            } else {
                $httpBody = $update_subscription_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
