<?php
/**
 * TransactionsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * MyWell Platform API
 *
 * # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes
 *
 * The version of the OpenAPI document: 2.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use OpenAPI\Client\ApiException;
use OpenAPI\Client\Configuration;
use OpenAPI\Client\FormDataProcessor;
use OpenAPI\Client\HeaderSelector;
use OpenAPI\Client\ObjectSerializer;

/**
 * TransactionsApi Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class TransactionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createTransaction' => [
            'application/json',
        ],
        'getTransaction' => [
            'application/json',
        ],
        'refundTransaction' => [
            'application/json',
        ],
        'searchTransactions' => [
            'application/json',
        ],
        'voidTransaction' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createTransaction
     *
     * Create transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateTransactionRequest $create_transaction_request create_transaction_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function createTransaction($x_authorization, $x_organization, $create_transaction_request, string $contentType = self::contentTypes['createTransaction'][0])
    {
        list($response) = $this->createTransactionWithHttpInfo($x_authorization, $x_organization, $create_transaction_request, $contentType);
        return $response;
    }

    /**
     * Operation createTransactionWithHttpInfo
     *
     * Create transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateTransactionRequest $create_transaction_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTransactionWithHttpInfo($x_authorization, $x_organization, $create_transaction_request, string $contentType = self::contentTypes['createTransaction'][0])
    {
        $request = $this->createTransactionRequest($x_authorization, $x_organization, $create_transaction_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\TransactionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createTransactionAsync
     *
     * Create transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateTransactionRequest $create_transaction_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTransactionAsync($x_authorization, $x_organization, $create_transaction_request, string $contentType = self::contentTypes['createTransaction'][0])
    {
        return $this->createTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $create_transaction_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTransactionAsyncWithHttpInfo
     *
     * Create transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateTransactionRequest $create_transaction_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $create_transaction_request, string $contentType = self::contentTypes['createTransaction'][0])
    {
        $returnType = '\OpenAPI\Client\Model\TransactionResponse';
        $request = $this->createTransactionRequest($x_authorization, $x_organization, $create_transaction_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTransaction'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\CreateTransactionRequest $create_transaction_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createTransactionRequest($x_authorization, $x_organization, $create_transaction_request, string $contentType = self::contentTypes['createTransaction'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling createTransaction'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling createTransaction'
            );
        }

        // verify the required parameter 'create_transaction_request' is set
        if ($create_transaction_request === null || (is_array($create_transaction_request) && count($create_transaction_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_transaction_request when calling createTransaction'
            );
        }


        $resourcePath = '/transaction';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_transaction_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_transaction_request));
            } else {
                $httpBody = $create_transaction_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTransaction
     *
     * Get transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function getTransaction($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getTransaction'][0])
    {
        list($response) = $this->getTransactionWithHttpInfo($x_authorization, $x_organization, $id, $contentType);
        return $response;
    }

    /**
     * Operation getTransactionWithHttpInfo
     *
     * Get transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTransactionWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getTransaction'][0])
    {
        $request = $this->getTransactionRequest($x_authorization, $x_organization, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\TransactionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getTransactionAsync
     *
     * Get transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransactionAsync($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getTransaction'][0])
    {
        return $this->getTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTransactionAsyncWithHttpInfo
     *
     * Get transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getTransaction'][0])
    {
        $returnType = '\OpenAPI\Client\Model\TransactionResponse';
        $request = $this->getTransactionRequest($x_authorization, $x_organization, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTransaction'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTransactionRequest($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['getTransaction'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling getTransaction'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling getTransaction'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getTransaction'
            );
        }


        $resourcePath = '/transaction/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation refundTransaction
     *
     * Refund transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  object|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function refundTransaction($x_authorization, $x_organization, $id, $body = null, string $contentType = self::contentTypes['refundTransaction'][0])
    {
        list($response) = $this->refundTransactionWithHttpInfo($x_authorization, $x_organization, $id, $body, $contentType);
        return $response;
    }

    /**
     * Operation refundTransactionWithHttpInfo
     *
     * Refund transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  object|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function refundTransactionWithHttpInfo($x_authorization, $x_organization, $id, $body = null, string $contentType = self::contentTypes['refundTransaction'][0])
    {
        $request = $this->refundTransactionRequest($x_authorization, $x_organization, $id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\TransactionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation refundTransactionAsync
     *
     * Refund transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  object|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundTransactionAsync($x_authorization, $x_organization, $id, $body = null, string $contentType = self::contentTypes['refundTransaction'][0])
    {
        return $this->refundTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation refundTransactionAsyncWithHttpInfo
     *
     * Refund transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  object|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $body = null, string $contentType = self::contentTypes['refundTransaction'][0])
    {
        $returnType = '\OpenAPI\Client\Model\TransactionResponse';
        $request = $this->refundTransactionRequest($x_authorization, $x_organization, $id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'refundTransaction'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  object|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function refundTransactionRequest($x_authorization, $x_organization, $id, $body = null, string $contentType = self::contentTypes['refundTransaction'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling refundTransaction'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling refundTransaction'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling refundTransaction'
            );
        }



        $resourcePath = '/transaction/{id}/refund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchTransactions
     *
     * Search transactions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\TransactionSearchRequest $transaction_search_request transaction_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchTransactions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\TransactionSearchResponse
     */
    public function searchTransactions($x_authorization, $x_organization, $transaction_search_request, string $contentType = self::contentTypes['searchTransactions'][0])
    {
        list($response) = $this->searchTransactionsWithHttpInfo($x_authorization, $x_organization, $transaction_search_request, $contentType);
        return $response;
    }

    /**
     * Operation searchTransactionsWithHttpInfo
     *
     * Search transactions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\TransactionSearchRequest $transaction_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchTransactions'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\TransactionSearchResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchTransactionsWithHttpInfo($x_authorization, $x_organization, $transaction_search_request, string $contentType = self::contentTypes['searchTransactions'][0])
    {
        $request = $this->searchTransactionsRequest($x_authorization, $x_organization, $transaction_search_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\TransactionSearchResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\TransactionSearchResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\TransactionSearchResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation searchTransactionsAsync
     *
     * Search transactions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\TransactionSearchRequest $transaction_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchTransactions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchTransactionsAsync($x_authorization, $x_organization, $transaction_search_request, string $contentType = self::contentTypes['searchTransactions'][0])
    {
        return $this->searchTransactionsAsyncWithHttpInfo($x_authorization, $x_organization, $transaction_search_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchTransactionsAsyncWithHttpInfo
     *
     * Search transactions
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\TransactionSearchRequest $transaction_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchTransactions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchTransactionsAsyncWithHttpInfo($x_authorization, $x_organization, $transaction_search_request, string $contentType = self::contentTypes['searchTransactions'][0])
    {
        $returnType = '\OpenAPI\Client\Model\TransactionSearchResponse';
        $request = $this->searchTransactionsRequest($x_authorization, $x_organization, $transaction_search_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchTransactions'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  \OpenAPI\Client\Model\TransactionSearchRequest $transaction_search_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchTransactions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchTransactionsRequest($x_authorization, $x_organization, $transaction_search_request, string $contentType = self::contentTypes['searchTransactions'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling searchTransactions'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling searchTransactions'
            );
        }

        // verify the required parameter 'transaction_search_request' is set
        if ($transaction_search_request === null || (is_array($transaction_search_request) && count($transaction_search_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transaction_search_request when calling searchTransactions'
            );
        }


        $resourcePath = '/transaction/search';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }



        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($transaction_search_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($transaction_search_request));
            } else {
                $httpBody = $transaction_search_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation voidTransaction
     *
     * Void transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['voidTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse
     */
    public function voidTransaction($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['voidTransaction'][0])
    {
        list($response) = $this->voidTransactionWithHttpInfo($x_authorization, $x_organization, $id, $contentType);
        return $response;
    }

    /**
     * Operation voidTransactionWithHttpInfo
     *
     * Void transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['voidTransaction'] to see the possible values for this operation
     *
     * @throws \OpenAPI\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \OpenAPI\Client\Model\TransactionResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse|\OpenAPI\Client\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function voidTransactionWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['voidTransaction'][0])
    {
        $request = $this->voidTransactionRequest($x_authorization, $x_organization, $id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $request,
                        $response,
                    );
                case 400:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 404:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
                case 401:
                    return $this->handleResponseWithDataType(
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\OpenAPI\Client\Model\TransactionResponse',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\TransactionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\OpenAPI\Client\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation voidTransactionAsync
     *
     * Void transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['voidTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function voidTransactionAsync($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['voidTransaction'][0])
    {
        return $this->voidTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation voidTransactionAsyncWithHttpInfo
     *
     * Void transaction
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['voidTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function voidTransactionAsyncWithHttpInfo($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['voidTransaction'][0])
    {
        $returnType = '\OpenAPI\Client\Model\TransactionResponse';
        $request = $this->voidTransactionRequest($x_authorization, $x_organization, $id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'voidTransaction'
     *
     * @param  string $x_authorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) (required)
     * @param  string $x_organization Organization ID that must match the integration&#39;s organization (required)
     * @param  string $id Transaction ID (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['voidTransaction'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function voidTransactionRequest($x_authorization, $x_organization, $id, string $contentType = self::contentTypes['voidTransaction'][0])
    {

        // verify the required parameter 'x_authorization' is set
        if ($x_authorization === null || (is_array($x_authorization) && count($x_authorization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_authorization when calling voidTransaction'
            );
        }

        // verify the required parameter 'x_organization' is set
        if ($x_organization === null || (is_array($x_organization) && count($x_organization) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $x_organization when calling voidTransaction'
            );
        }

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling voidTransaction'
            );
        }


        $resourcePath = '/transaction/{id}/void';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // header params
        if ($x_authorization !== null) {
            $headerParams['X-Authorization'] = ObjectSerializer::toHeaderValue($x_authorization);
        }
        // header params
        if ($x_organization !== null) {
            $headerParams['X-Organization'] = ObjectSerializer::toHeaderValue($x_organization);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        if ($this->config->getCertFile()) {
            $options[RequestOptions::CERT] = $this->config->getCertFile();
        }

        if ($this->config->getKeyFile()) {
            $options[RequestOptions::SSL_KEY] = $this->config->getKeyFile();
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
