<?php
/**
 * TransactionResponse
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * MyWell Platform API
 *
 * # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes
 *
 * The version of the OpenAPI document: 2.0.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.17.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace OpenAPI\Client\Model;

use \ArrayAccess;
use \OpenAPI\Client\ObjectSerializer;

/**
 * TransactionResponse Class Doc Comment
 *
 * @category Class
 * @package  OpenAPI\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransactionResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TransactionResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'type' => 'string',
        'amount' => 'int',
        'gift_amount' => 'int',
        'fee_amount' => 'float',
        'fee_rate' => 'float',
        'fees_covered' => 'bool',
        'status' => 'string',
        'customer_id' => 'string',
        'subscription_id' => 'string',
        'description' => 'string',
        'created_at' => '\DateTime',
        'settled_at' => '\DateTime',
        'customer' => '\OpenAPI\Client\Model\TransactionResponseCustomer',
        'payment_method' => '\OpenAPI\Client\Model\PaymentMethod',
        'campus' => '\OpenAPI\Client\Model\TransactionResponseCampus',
        'funds' => '\OpenAPI\Client\Model\TransactionResponseFundsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'type' => null,
        'amount' => null,
        'gift_amount' => null,
        'fee_amount' => null,
        'fee_rate' => null,
        'fees_covered' => null,
        'status' => null,
        'customer_id' => null,
        'subscription_id' => null,
        'description' => null,
        'created_at' => 'date-time',
        'settled_at' => 'date-time',
        'customer' => null,
        'payment_method' => null,
        'campus' => null,
        'funds' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'type' => false,
        'amount' => false,
        'gift_amount' => false,
        'fee_amount' => true,
        'fee_rate' => true,
        'fees_covered' => false,
        'status' => false,
        'customer_id' => false,
        'subscription_id' => true,
        'description' => true,
        'created_at' => false,
        'settled_at' => true,
        'customer' => false,
        'payment_method' => false,
        'campus' => true,
        'funds' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'type' => 'type',
        'amount' => 'amount',
        'gift_amount' => 'giftAmount',
        'fee_amount' => 'feeAmount',
        'fee_rate' => 'feeRate',
        'fees_covered' => 'feesCovered',
        'status' => 'status',
        'customer_id' => 'customerId',
        'subscription_id' => 'subscriptionId',
        'description' => 'description',
        'created_at' => 'createdAt',
        'settled_at' => 'settledAt',
        'customer' => 'customer',
        'payment_method' => 'paymentMethod',
        'campus' => 'campus',
        'funds' => 'funds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'type' => 'setType',
        'amount' => 'setAmount',
        'gift_amount' => 'setGiftAmount',
        'fee_amount' => 'setFeeAmount',
        'fee_rate' => 'setFeeRate',
        'fees_covered' => 'setFeesCovered',
        'status' => 'setStatus',
        'customer_id' => 'setCustomerId',
        'subscription_id' => 'setSubscriptionId',
        'description' => 'setDescription',
        'created_at' => 'setCreatedAt',
        'settled_at' => 'setSettledAt',
        'customer' => 'setCustomer',
        'payment_method' => 'setPaymentMethod',
        'campus' => 'setCampus',
        'funds' => 'setFunds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'type' => 'getType',
        'amount' => 'getAmount',
        'gift_amount' => 'getGiftAmount',
        'fee_amount' => 'getFeeAmount',
        'fee_rate' => 'getFeeRate',
        'fees_covered' => 'getFeesCovered',
        'status' => 'getStatus',
        'customer_id' => 'getCustomerId',
        'subscription_id' => 'getSubscriptionId',
        'description' => 'getDescription',
        'created_at' => 'getCreatedAt',
        'settled_at' => 'getSettledAt',
        'customer' => 'getCustomer',
        'payment_method' => 'getPaymentMethod',
        'campus' => 'getCampus',
        'funds' => 'getFunds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('gift_amount', $data ?? [], null);
        $this->setIfExists('fee_amount', $data ?? [], null);
        $this->setIfExists('fee_rate', $data ?? [], null);
        $this->setIfExists('fees_covered', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('customer_id', $data ?? [], null);
        $this->setIfExists('subscription_id', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('created_at', $data ?? [], null);
        $this->setIfExists('settled_at', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('payment_method', $data ?? [], null);
        $this->setIfExists('campus', $data ?? [], null);
        $this->setIfExists('funds', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return int|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param int|null $amount Total amount in cents
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets gift_amount
     *
     * @return int|null
     */
    public function getGiftAmount()
    {
        return $this->container['gift_amount'];
    }

    /**
     * Sets gift_amount
     *
     * @param int|null $gift_amount Gift amount in cents (net to organization)
     *
     * @return self
     */
    public function setGiftAmount($gift_amount)
    {
        if (is_null($gift_amount)) {
            throw new \InvalidArgumentException('non-nullable gift_amount cannot be null');
        }
        $this->container['gift_amount'] = $gift_amount;

        return $this;
    }

    /**
     * Gets fee_amount
     *
     * @return float|null
     */
    public function getFeeAmount()
    {
        return $this->container['fee_amount'];
    }

    /**
     * Sets fee_amount
     *
     * @param float|null $fee_amount Fee amount
     *
     * @return self
     */
    public function setFeeAmount($fee_amount)
    {
        if (is_null($fee_amount)) {
            array_push($this->openAPINullablesSetToNull, 'fee_amount');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fee_amount', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fee_amount'] = $fee_amount;

        return $this;
    }

    /**
     * Gets fee_rate
     *
     * @return float|null
     */
    public function getFeeRate()
    {
        return $this->container['fee_rate'];
    }

    /**
     * Sets fee_rate
     *
     * @param float|null $fee_rate Fee rate percentage
     *
     * @return self
     */
    public function setFeeRate($fee_rate)
    {
        if (is_null($fee_rate)) {
            array_push($this->openAPINullablesSetToNull, 'fee_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('fee_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['fee_rate'] = $fee_rate;

        return $this;
    }

    /**
     * Gets fees_covered
     *
     * @return bool|null
     */
    public function getFeesCovered()
    {
        return $this->container['fees_covered'];
    }

    /**
     * Sets fees_covered
     *
     * @param bool|null $fees_covered fees_covered
     *
     * @return self
     */
    public function setFeesCovered($fees_covered)
    {
        if (is_null($fees_covered)) {
            throw new \InvalidArgumentException('non-nullable fees_covered cannot be null');
        }
        $this->container['fees_covered'] = $fees_covered;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id customer_id
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        if (is_null($customer_id)) {
            throw new \InvalidArgumentException('non-nullable customer_id cannot be null');
        }
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets subscription_id
     *
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->container['subscription_id'];
    }

    /**
     * Sets subscription_id
     *
     * @param string|null $subscription_id subscription_id
     *
     * @return self
     */
    public function setSubscriptionId($subscription_id)
    {
        if (is_null($subscription_id)) {
            array_push($this->openAPINullablesSetToNull, 'subscription_id');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('subscription_id', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['subscription_id'] = $subscription_id;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            array_push($this->openAPINullablesSetToNull, 'description');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('description', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return \DateTime|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param \DateTime|null $created_at created_at
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        if (is_null($created_at)) {
            throw new \InvalidArgumentException('non-nullable created_at cannot be null');
        }
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets settled_at
     *
     * @return \DateTime|null
     */
    public function getSettledAt()
    {
        return $this->container['settled_at'];
    }

    /**
     * Sets settled_at
     *
     * @param \DateTime|null $settled_at settled_at
     *
     * @return self
     */
    public function setSettledAt($settled_at)
    {
        if (is_null($settled_at)) {
            array_push($this->openAPINullablesSetToNull, 'settled_at');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('settled_at', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['settled_at'] = $settled_at;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \OpenAPI\Client\Model\TransactionResponseCustomer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \OpenAPI\Client\Model\TransactionResponseCustomer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets payment_method
     *
     * @return \OpenAPI\Client\Model\PaymentMethod|null
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     *
     * @param \OpenAPI\Client\Model\PaymentMethod|null $payment_method payment_method
     *
     * @return self
     */
    public function setPaymentMethod($payment_method)
    {
        if (is_null($payment_method)) {
            throw new \InvalidArgumentException('non-nullable payment_method cannot be null');
        }
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets campus
     *
     * @return \OpenAPI\Client\Model\TransactionResponseCampus|null
     */
    public function getCampus()
    {
        return $this->container['campus'];
    }

    /**
     * Sets campus
     *
     * @param \OpenAPI\Client\Model\TransactionResponseCampus|null $campus campus
     *
     * @return self
     */
    public function setCampus($campus)
    {
        if (is_null($campus)) {
            array_push($this->openAPINullablesSetToNull, 'campus');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('campus', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['campus'] = $campus;

        return $this;
    }

    /**
     * Gets funds
     *
     * @return \OpenAPI\Client\Model\TransactionResponseFundsInner[]|null
     */
    public function getFunds()
    {
        return $this->container['funds'];
    }

    /**
     * Sets funds
     *
     * @param \OpenAPI\Client\Model\TransactionResponseFundsInner[]|null $funds funds
     *
     * @return self
     */
    public function setFunds($funds)
    {
        if (is_null($funds)) {
            throw new \InvalidArgumentException('non-nullable funds cannot be null');
        }
        $this->container['funds'] = $funds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer|string $offset Offset
     *
     * @return boolean
     */
    public function offsetExists(mixed $offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet(mixed $offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer|string $offset Offset
     *
     * @return void
     */
    public function offsetUnset(mixed $offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


