# openapi-client
# MyWell Platform API

This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.

## Authentication

### Token Exchange Endpoints

**Initial Token Exchange (`GET /api/v2/auth/access`):**
- Requires: `ACCESS_TOKEN` header only
- Returns: `organizationId` along with tokens

**Refresh Token Exchange (`GET /api/v2/auth/refresh`):**
- Requires: `REFRESH_TOKEN` and `X-Organization` headers

### API Requests

All other API requests require two headers:
1. **X-Authorization**: Bearer token for authentication
2. **X-Organization**: Organization ID that must match the integration's organization

```
X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN
X-Organization: YOUR_ORGANIZATION_ID
```

The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.

## Pagination
Search endpoints support cursor-based pagination:
1. **First Request:** Send request without `cursor`
2. **Response:** Check `pagination.cursor` in response body for next page cursor
3. **Next Request:** Include `cursor` in request body
4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)

**Limit Constraints:**
- Default limit: 20 results per page
- Maximum limit: 100 results per page
- Minimum limit: Must be greater than 0
- Cursors expire after 5 minutes


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 1.0.0
- Generator version: 7.17.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import openapi_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import openapi_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import openapi_client
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)



# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AuthenticationApi(api_client)
    access_token = 'access_token_example' # str | Access token from integration creation

    try:
        # Initial token exchange
        api_response = api_instance.use_access_token(access_token)
        print("The response of AuthenticationApi->use_access_token:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthenticationApi->use_access_token: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.mywell.org/api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**use_access_token**](docs/AuthenticationApi.md#use_access_token) | **GET** /auth/access | Initial token exchange
*AuthenticationApi* | [**use_refresh_token**](docs/AuthenticationApi.md#use_refresh_token) | **GET** /auth/refresh | Refresh token
*CampusesApi* | [**search_campuses**](docs/CampusesApi.md#search_campuses) | **POST** /campus/search | Search campuses
*CustomersApi* | [**add_payment_method**](docs/CustomersApi.md#add_payment_method) | **POST** /customer/{id}/paymentMethod | Add payment method
*CustomersApi* | [**create_customer**](docs/CustomersApi.md#create_customer) | **POST** /customer | Create customer
*CustomersApi* | [**create_customer_address**](docs/CustomersApi.md#create_customer_address) | **POST** /customer/{id}/address | Create customer address
*CustomersApi* | [**delete_customer_address**](docs/CustomersApi.md#delete_customer_address) | **DELETE** /customer/{id}/address/{id2} | Delete customer address
*CustomersApi* | [**delete_payment_method**](docs/CustomersApi.md#delete_payment_method) | **DELETE** /customer/{id}/paymentMethod/{id2} | Delete payment method
*CustomersApi* | [**get_customer**](docs/CustomersApi.md#get_customer) | **GET** /customer/{id} | Get customer
*CustomersApi* | [**get_customer_addresses**](docs/CustomersApi.md#get_customer_addresses) | **GET** /customer/{id}/address | Get customer addresses
*CustomersApi* | [**get_customer_payment_methods**](docs/CustomersApi.md#get_customer_payment_methods) | **GET** /customer/{id}/paymentMethod | Get customer payment methods
*CustomersApi* | [**search_customers**](docs/CustomersApi.md#search_customers) | **POST** /customer/search | Search customers
*CustomersApi* | [**update_customer**](docs/CustomersApi.md#update_customer) | **PUT** /customer/{id} | Update customer
*FundsApi* | [**search_funds**](docs/FundsApi.md#search_funds) | **POST** /fund/search | Search funds
*SubscriptionsApi* | [**create_subscription**](docs/SubscriptionsApi.md#create_subscription) | **POST** /subscription | Create subscription
*SubscriptionsApi* | [**get_subscription**](docs/SubscriptionsApi.md#get_subscription) | **GET** /subscription/{id} | Get subscription
*SubscriptionsApi* | [**search_subscriptions**](docs/SubscriptionsApi.md#search_subscriptions) | **POST** /subscription/search | Search subscriptions
*SubscriptionsApi* | [**update_subscription**](docs/SubscriptionsApi.md#update_subscription) | **PUT** /subscription/{id} | Update subscription
*TransactionsApi* | [**create_transaction**](docs/TransactionsApi.md#create_transaction) | **POST** /transaction | Create transaction
*TransactionsApi* | [**get_transaction**](docs/TransactionsApi.md#get_transaction) | **GET** /transaction/{id} | Get transaction
*TransactionsApi* | [**refund_transaction**](docs/TransactionsApi.md#refund_transaction) | **POST** /transaction/{id}/refund | Refund transaction
*TransactionsApi* | [**search_transactions**](docs/TransactionsApi.md#search_transactions) | **POST** /transaction/search | Search transactions
*TransactionsApi* | [**void_transaction**](docs/TransactionsApi.md#void_transaction) | **POST** /transaction/{id}/void | Void transaction


## Documentation For Models

 - [AddPaymentMethodRequest](docs/AddPaymentMethodRequest.md)
 - [Address](docs/Address.md)
 - [AddressListResponse](docs/AddressListResponse.md)
 - [AmountRange](docs/AmountRange.md)
 - [BillingAddress](docs/BillingAddress.md)
 - [Campus](docs/Campus.md)
 - [CampusSearchRequest](docs/CampusSearchRequest.md)
 - [CampusSearchResponse](docs/CampusSearchResponse.md)
 - [CreateAddressRequest](docs/CreateAddressRequest.md)
 - [CreateCustomerRequest](docs/CreateCustomerRequest.md)
 - [CreateSubscriptionRequest](docs/CreateSubscriptionRequest.md)
 - [CreateTransactionRequest](docs/CreateTransactionRequest.md)
 - [CustomerResponse](docs/CustomerResponse.md)
 - [CustomerSearchRequest](docs/CustomerSearchRequest.md)
 - [CustomerSearchResponse](docs/CustomerSearchResponse.md)
 - [DateRange](docs/DateRange.md)
 - [DeletePaymentMethod200Response](docs/DeletePaymentMethod200Response.md)
 - [DeletePaymentMethod200ResponseData](docs/DeletePaymentMethod200ResponseData.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Fund](docs/Fund.md)
 - [FundAllocation](docs/FundAllocation.md)
 - [FundSearchRequest](docs/FundSearchRequest.md)
 - [FundSearchResponse](docs/FundSearchResponse.md)
 - [Pagination](docs/Pagination.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodInput](docs/PaymentMethodInput.md)
 - [PaymentMethodListResponse](docs/PaymentMethodListResponse.md)
 - [SubscriptionResponse](docs/SubscriptionResponse.md)
 - [SubscriptionSearchRequest](docs/SubscriptionSearchRequest.md)
 - [SubscriptionSearchResponse](docs/SubscriptionSearchResponse.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [TransactionResponse](docs/TransactionResponse.md)
 - [TransactionResponseCampus](docs/TransactionResponseCampus.md)
 - [TransactionResponseCustomer](docs/TransactionResponseCustomer.md)
 - [TransactionResponseFundsInner](docs/TransactionResponseFundsInner.md)
 - [TransactionSearchRequest](docs/TransactionSearchRequest.md)
 - [TransactionSearchResponse](docs/TransactionSearchResponse.md)
 - [UpdateAddressRequest](docs/UpdateAddressRequest.md)
 - [UpdateCustomerRequest](docs/UpdateCustomerRequest.md)
 - [UpdateSubscriptionRequest](docs/UpdateSubscriptionRequest.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




