# openapi_client.AuthenticationApi

All URIs are relative to *https://api.mywell.org/api/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**use_access_token**](AuthenticationApi.md#use_access_token) | **GET** /auth/access | Initial token exchange
[**use_refresh_token**](AuthenticationApi.md#use_refresh_token) | **GET** /auth/refresh | Refresh token


# **use_access_token**
> TokenResponse use_access_token(access_token)

Initial token exchange

One-time use endpoint for initial token exchange. Only works when integration is disabled.
After successful use, the integration is enabled and this endpoint becomes unusable.

**Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response.


### Example


```python
import openapi_client
from openapi_client.models.token_response import TokenResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AuthenticationApi(api_client)
    access_token = 'access_token_example' # str | Access token from integration creation

    try:
        # Initial token exchange
        api_response = api_instance.use_access_token(access_token)
        print("The response of AuthenticationApi->use_access_token:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AuthenticationApi->use_access_token: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **access_token** | **str**| Access token from integration creation | 

### Return type

[**TokenResponse**](TokenResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful token exchange |  -  |
**400** | Bad request |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **use_refresh_token**
> TokenResponse use_refresh_token(refresh_token, x_organization)

Refresh token

Get new tokens using refresh token

### Example


```python
import openapi_client
from openapi_client.models.token_response import TokenResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.AuthenticationApi(api_client)
    refresh_token = 'refresh_token_example' # str | Refresh token from previous token exchange
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization

    try:
        # Refresh token
        api_response = api_instance.use_refresh_token(refresh_token, x_organization)
        print("The response of AuthenticationApi->use_refresh_token:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling AuthenticationApi->use_refresh_token: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **refresh_token** | **str**| Refresh token from previous token exchange | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 

### Return type

[**TokenResponse**](TokenResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful token refresh |  -  |
**400** | Bad request |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

