# openapi_client.CampusesApi

All URIs are relative to *https://api.mywell.org/api/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**search_campuses**](CampusesApi.md#search_campuses) | **POST** /campus/search | Search campuses


# **search_campuses**
> CampusSearchResponse search_campuses(x_authorization, x_organization, campus_search_request)

Search campuses

Search for campuses with optional filters and pagination

### Example


```python
import openapi_client
from openapi_client.models.campus_search_request import CampusSearchRequest
from openapi_client.models.campus_search_response import CampusSearchResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CampusesApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    campus_search_request = openapi_client.CampusSearchRequest() # CampusSearchRequest | 

    try:
        # Search campuses
        api_response = api_instance.search_campuses(x_authorization, x_organization, campus_search_request)
        print("The response of CampusesApi->search_campuses:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CampusesApi->search_campuses: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **campus_search_request** | [**CampusSearchRequest**](CampusSearchRequest.md)|  | 

### Return type

[**CampusSearchResponse**](CampusSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

