# CreateSubscriptionRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**amount** | **int** | Subscription amount in cents (minimum 100 cents &#x3D; $1.00) | 
**frequency** | **str** |  | 
**start_date** | **date** | Start date in YYYY-MM-DD format | 
**customer_id** | **str** |  | 
**payment_method_id** | **str** | Payment method database ID | 
**campus_id** | **str** | Campus ID (defaults to oldest active campus with active funds if not provided) | [optional] 
**fund_id** | **str** | Single fund ID (mutually exclusive with funds) | [optional] 
**funds** | [**List[FundAllocation]**](FundAllocation.md) | Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled) | [optional] 
**description** | **str** |  | [optional] 
**fees_covered** | **bool** | Whether donor covers processing fees | [optional] [default to False]

## Example

```python
from openapi_client.models.create_subscription_request import CreateSubscriptionRequest

# TODO update the JSON string below
json = "{}"
# create an instance of CreateSubscriptionRequest from a JSON string
create_subscription_request_instance = CreateSubscriptionRequest.from_json(json)
# print the JSON string representation of the object
print(CreateSubscriptionRequest.to_json())

# convert the object into a dict
create_subscription_request_dict = create_subscription_request_instance.to_dict()
# create an instance of CreateSubscriptionRequest from a dict
create_subscription_request_from_dict = CreateSubscriptionRequest.from_dict(create_subscription_request_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


