# CreateTransactionRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**amount** | **int** | Amount in cents (minimum 1 cent &#x3D; $0.01) | 
**customer_id** | **str** |  | 
**payment_method_id** | **str** | Payment method database ID | 
**campus_id** | **str** | Campus ID (defaults to oldest active campus with active funds if not provided) | [optional] 
**fund_id** | **str** | Single fund ID (mutually exclusive with funds) | [optional] 
**funds** | [**List[FundAllocation]**](FundAllocation.md) | Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled) | [optional] 
**description** | **str** |  | [optional] 
**fees_covered** | **bool** | Whether customer covers processing fees | [optional] [default to False]

## Example

```python
from openapi_client.models.create_transaction_request import CreateTransactionRequest

# TODO update the JSON string below
json = "{}"
# create an instance of CreateTransactionRequest from a JSON string
create_transaction_request_instance = CreateTransactionRequest.from_json(json)
# print the JSON string representation of the object
print(CreateTransactionRequest.to_json())

# convert the object into a dict
create_transaction_request_dict = create_transaction_request_instance.to_dict()
# create an instance of CreateTransactionRequest from a dict
create_transaction_request_from_dict = CreateTransactionRequest.from_dict(create_transaction_request_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


