# openapi_client.CustomersApi

All URIs are relative to *https://api.mywell.org/api/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**add_payment_method**](CustomersApi.md#add_payment_method) | **POST** /customer/{id}/paymentMethod | Add payment method
[**create_customer**](CustomersApi.md#create_customer) | **POST** /customer | Create customer
[**create_customer_address**](CustomersApi.md#create_customer_address) | **POST** /customer/{id}/address | Create customer address
[**delete_customer_address**](CustomersApi.md#delete_customer_address) | **DELETE** /customer/{id}/address/{id2} | Delete customer address
[**delete_payment_method**](CustomersApi.md#delete_payment_method) | **DELETE** /customer/{id}/paymentMethod/{id2} | Delete payment method
[**get_customer**](CustomersApi.md#get_customer) | **GET** /customer/{id} | Get customer
[**get_customer_addresses**](CustomersApi.md#get_customer_addresses) | **GET** /customer/{id}/address | Get customer addresses
[**get_customer_payment_methods**](CustomersApi.md#get_customer_payment_methods) | **GET** /customer/{id}/paymentMethod | Get customer payment methods
[**search_customers**](CustomersApi.md#search_customers) | **POST** /customer/search | Search customers
[**update_customer**](CustomersApi.md#update_customer) | **PUT** /customer/{id} | Update customer


# **add_payment_method**
> PaymentMethod add_payment_method(x_authorization, x_organization, id, add_payment_method_request)

Add payment method

Add a payment method to a customer

### Example


```python
import openapi_client
from openapi_client.models.add_payment_method_request import AddPaymentMethodRequest
from openapi_client.models.payment_method import PaymentMethod
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID
    add_payment_method_request = openapi_client.AddPaymentMethodRequest() # AddPaymentMethodRequest | 

    try:
        # Add payment method
        api_response = api_instance.add_payment_method(x_authorization, x_organization, id, add_payment_method_request)
        print("The response of CustomersApi->add_payment_method:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->add_payment_method: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 
 **add_payment_method_request** | [**AddPaymentMethodRequest**](AddPaymentMethodRequest.md)|  | 

### Return type

[**PaymentMethod**](PaymentMethod.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payment method added successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_customer**
> CustomerResponse create_customer(x_authorization, x_organization, create_customer_request)

Create customer

Create a new customer with payment method

### Example


```python
import openapi_client
from openapi_client.models.create_customer_request import CreateCustomerRequest
from openapi_client.models.customer_response import CustomerResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    create_customer_request = {"kind":"DONATION","description":"New customer via Platform API","paymentMethod":{"token":"tok_visa_1234567890abcdef"},"firstName":"John","lastName":"Doe","email":"john.doe@example.com","phone":"555-123-4567","billingAddress":{"street1":"123 Main Street","street2":"Apt 4B","city":"New York","state":"NY","postalCode":"10001","country":"US"},"clientType":"WEB"} # CreateCustomerRequest | 

    try:
        # Create customer
        api_response = api_instance.create_customer(x_authorization, x_organization, create_customer_request)
        print("The response of CustomersApi->create_customer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->create_customer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **create_customer_request** | [**CreateCustomerRequest**](CreateCustomerRequest.md)|  | 

### Return type

[**CustomerResponse**](CustomerResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Customer created successfully |  -  |
**400** | Bad request |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **create_customer_address**
> Address create_customer_address(x_authorization, x_organization, id, create_address_request)

Create customer address

Create a new address for a customer

### Example


```python
import openapi_client
from openapi_client.models.address import Address
from openapi_client.models.create_address_request import CreateAddressRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID
    create_address_request = openapi_client.CreateAddressRequest() # CreateAddressRequest | 

    try:
        # Create customer address
        api_response = api_instance.create_customer_address(x_authorization, x_organization, id, create_address_request)
        print("The response of CustomersApi->create_customer_address:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->create_customer_address: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 
 **create_address_request** | [**CreateAddressRequest**](CreateAddressRequest.md)|  | 

### Return type

[**Address**](Address.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Address created successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_customer_address**
> DeletePaymentMethod200Response delete_customer_address(x_authorization, x_organization, id, id2)

Delete customer address

Delete an address from a customer

### Example


```python
import openapi_client
from openapi_client.models.delete_payment_method200_response import DeletePaymentMethod200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID
    id2 = 'id2_example' # str | Address ID

    try:
        # Delete customer address
        api_response = api_instance.delete_customer_address(x_authorization, x_organization, id, id2)
        print("The response of CustomersApi->delete_customer_address:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->delete_customer_address: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 
 **id2** | **str**| Address ID | 

### Return type

[**DeletePaymentMethod200Response**](DeletePaymentMethod200Response.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Address deleted successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **delete_payment_method**
> DeletePaymentMethod200Response delete_payment_method(x_authorization, x_organization, id, id2)

Delete payment method

Delete a payment method from a customer

### Example


```python
import openapi_client
from openapi_client.models.delete_payment_method200_response import DeletePaymentMethod200Response
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID
    id2 = 'id2_example' # str | Payment method ID

    try:
        # Delete payment method
        api_response = api_instance.delete_payment_method(x_authorization, x_organization, id, id2)
        print("The response of CustomersApi->delete_payment_method:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->delete_payment_method: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 
 **id2** | **str**| Payment method ID | 

### Return type

[**DeletePaymentMethod200Response**](DeletePaymentMethod200Response.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Payment method deleted successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_customer**
> CustomerResponse get_customer(x_authorization, x_organization, id)

Get customer

Get customer by ID

### Example


```python
import openapi_client
from openapi_client.models.customer_response import CustomerResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID

    try:
        # Get customer
        api_response = api_instance.get_customer(x_authorization, x_organization, id)
        print("The response of CustomersApi->get_customer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->get_customer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 

### Return type

[**CustomerResponse**](CustomerResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Customer details |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_customer_addresses**
> AddressListResponse get_customer_addresses(x_authorization, x_organization, id)

Get customer addresses

Get all addresses for a customer

### Example


```python
import openapi_client
from openapi_client.models.address_list_response import AddressListResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID

    try:
        # Get customer addresses
        api_response = api_instance.get_customer_addresses(x_authorization, x_organization, id)
        print("The response of CustomersApi->get_customer_addresses:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->get_customer_addresses: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 

### Return type

[**AddressListResponse**](AddressListResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of addresses |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_customer_payment_methods**
> PaymentMethodListResponse get_customer_payment_methods(x_authorization, x_organization, id)

Get customer payment methods

Get all payment methods for a customer

### Example


```python
import openapi_client
from openapi_client.models.payment_method_list_response import PaymentMethodListResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID

    try:
        # Get customer payment methods
        api_response = api_instance.get_customer_payment_methods(x_authorization, x_organization, id)
        print("The response of CustomersApi->get_customer_payment_methods:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->get_customer_payment_methods: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 

### Return type

[**PaymentMethodListResponse**](PaymentMethodListResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | List of payment methods |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_customers**
> CustomerSearchResponse search_customers(x_authorization, x_organization, customer_search_request)

Search customers

Search for customers with optional filters and pagination

### Example


```python
import openapi_client
from openapi_client.models.customer_search_request import CustomerSearchRequest
from openapi_client.models.customer_search_response import CustomerSearchResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    customer_search_request = openapi_client.CustomerSearchRequest() # CustomerSearchRequest | 

    try:
        # Search customers
        api_response = api_instance.search_customers(x_authorization, x_organization, customer_search_request)
        print("The response of CustomersApi->search_customers:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->search_customers: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **customer_search_request** | [**CustomerSearchRequest**](CustomerSearchRequest.md)|  | 

### Return type

[**CustomerSearchResponse**](CustomerSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_customer**
> CustomerResponse update_customer(x_authorization, x_organization, id, update_customer_request)

Update customer

Update customer information

### Example


```python
import openapi_client
from openapi_client.models.customer_response import CustomerResponse
from openapi_client.models.update_customer_request import UpdateCustomerRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.CustomersApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Customer ID
    update_customer_request = openapi_client.UpdateCustomerRequest() # UpdateCustomerRequest | 

    try:
        # Update customer
        api_response = api_instance.update_customer(x_authorization, x_organization, id, update_customer_request)
        print("The response of CustomersApi->update_customer:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling CustomersApi->update_customer: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Customer ID | 
 **update_customer_request** | [**UpdateCustomerRequest**](UpdateCustomerRequest.md)|  | 

### Return type

[**CustomerResponse**](CustomerResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Customer updated successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

