# openapi_client.FundsApi

All URIs are relative to *https://api.mywell.org/api/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**search_funds**](FundsApi.md#search_funds) | **POST** /fund/search | Search funds


# **search_funds**
> FundSearchResponse search_funds(x_authorization, x_organization, fund_search_request)

Search funds

Search for funds with optional filters and pagination

### Example


```python
import openapi_client
from openapi_client.models.fund_search_request import FundSearchRequest
from openapi_client.models.fund_search_response import FundSearchResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.FundsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    fund_search_request = openapi_client.FundSearchRequest() # FundSearchRequest | 

    try:
        # Search funds
        api_response = api_instance.search_funds(x_authorization, x_organization, fund_search_request)
        print("The response of FundsApi->search_funds:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling FundsApi->search_funds: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **fund_search_request** | [**FundSearchRequest**](FundSearchRequest.md)|  | 

### Return type

[**FundSearchResponse**](FundSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

