# openapi_client.SubscriptionsApi

All URIs are relative to *https://api.mywell.org/api/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_subscription**](SubscriptionsApi.md#create_subscription) | **POST** /subscription | Create subscription
[**get_subscription**](SubscriptionsApi.md#get_subscription) | **GET** /subscription/{id} | Get subscription
[**search_subscriptions**](SubscriptionsApi.md#search_subscriptions) | **POST** /subscription/search | Search subscriptions
[**update_subscription**](SubscriptionsApi.md#update_subscription) | **PUT** /subscription/{id} | Update subscription


# **create_subscription**
> SubscriptionResponse create_subscription(x_authorization, x_organization, create_subscription_request)

Create subscription

Create a new subscription

### Example


```python
import openapi_client
from openapi_client.models.create_subscription_request import CreateSubscriptionRequest
from openapi_client.models.subscription_response import SubscriptionResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SubscriptionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    create_subscription_request = {"amount":2500,"frequency":"MONTHLY","startDate":"2024-01-15","customerId":"cmfl3x8be0001bkh9e2geb994","paymentMethodId":"cmfmnfgiq000hmgyucovh836z","campusId":"cmfl3x8be0001bkh9e2geb994","description":"Monthly recurring donation","fundId":"ck9u2gs9s01xh0746q15yeooe"} # CreateSubscriptionRequest | 

    try:
        # Create subscription
        api_response = api_instance.create_subscription(x_authorization, x_organization, create_subscription_request)
        print("The response of SubscriptionsApi->create_subscription:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SubscriptionsApi->create_subscription: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **create_subscription_request** | [**CreateSubscriptionRequest**](CreateSubscriptionRequest.md)|  | 

### Return type

[**SubscriptionResponse**](SubscriptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Subscription created successfully |  -  |
**400** | Bad request |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_subscription**
> SubscriptionResponse get_subscription(x_authorization, x_organization, id)

Get subscription

Get subscription by ID

### Example


```python
import openapi_client
from openapi_client.models.subscription_response import SubscriptionResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SubscriptionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Subscription ID

    try:
        # Get subscription
        api_response = api_instance.get_subscription(x_authorization, x_organization, id)
        print("The response of SubscriptionsApi->get_subscription:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SubscriptionsApi->get_subscription: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Subscription ID | 

### Return type

[**SubscriptionResponse**](SubscriptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Subscription details |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_subscriptions**
> SubscriptionSearchResponse search_subscriptions(x_authorization, x_organization, subscription_search_request)

Search subscriptions

Search for subscriptions with optional filters and pagination

### Example


```python
import openapi_client
from openapi_client.models.subscription_search_request import SubscriptionSearchRequest
from openapi_client.models.subscription_search_response import SubscriptionSearchResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SubscriptionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    subscription_search_request = openapi_client.SubscriptionSearchRequest() # SubscriptionSearchRequest | 

    try:
        # Search subscriptions
        api_response = api_instance.search_subscriptions(x_authorization, x_organization, subscription_search_request)
        print("The response of SubscriptionsApi->search_subscriptions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SubscriptionsApi->search_subscriptions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **subscription_search_request** | [**SubscriptionSearchRequest**](SubscriptionSearchRequest.md)|  | 

### Return type

[**SubscriptionSearchResponse**](SubscriptionSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **update_subscription**
> SubscriptionResponse update_subscription(x_authorization, x_organization, id, update_subscription_request)

Update subscription

Update subscription details

### Example


```python
import openapi_client
from openapi_client.models.subscription_response import SubscriptionResponse
from openapi_client.models.update_subscription_request import UpdateSubscriptionRequest
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.SubscriptionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Subscription ID
    update_subscription_request = openapi_client.UpdateSubscriptionRequest() # UpdateSubscriptionRequest | 

    try:
        # Update subscription
        api_response = api_instance.update_subscription(x_authorization, x_organization, id, update_subscription_request)
        print("The response of SubscriptionsApi->update_subscription:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling SubscriptionsApi->update_subscription: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Subscription ID | 
 **update_subscription_request** | [**UpdateSubscriptionRequest**](UpdateSubscriptionRequest.md)|  | 

### Return type

[**SubscriptionResponse**](SubscriptionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Subscription updated successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

