# TransactionResponse


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **str** |  | [optional] 
**type** | **str** |  | [optional] 
**amount** | **int** | Total amount in cents | [optional] 
**gift_amount** | **int** | Gift amount in cents (net to organization) | [optional] 
**fee_amount** | **float** | Fee amount | [optional] 
**fee_rate** | **float** | Fee rate percentage | [optional] 
**fees_covered** | **bool** |  | [optional] 
**status** | **str** |  | [optional] 
**customer_id** | **str** |  | [optional] 
**subscription_id** | **str** |  | [optional] 
**description** | **str** |  | [optional] 
**created_at** | **datetime** |  | [optional] 
**settled_at** | **datetime** |  | [optional] 
**customer** | [**TransactionResponseCustomer**](TransactionResponseCustomer.md) |  | [optional] 
**payment_method** | [**PaymentMethod**](PaymentMethod.md) |  | [optional] 
**campus** | [**TransactionResponseCampus**](TransactionResponseCampus.md) |  | [optional] 
**funds** | [**List[TransactionResponseFundsInner]**](TransactionResponseFundsInner.md) |  | [optional] 

## Example

```python
from openapi_client.models.transaction_response import TransactionResponse

# TODO update the JSON string below
json = "{}"
# create an instance of TransactionResponse from a JSON string
transaction_response_instance = TransactionResponse.from_json(json)
# print the JSON string representation of the object
print(TransactionResponse.to_json())

# convert the object into a dict
transaction_response_dict = transaction_response_instance.to_dict()
# create an instance of TransactionResponse from a dict
transaction_response_from_dict = TransactionResponse.from_dict(transaction_response_dict)
```
[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


