# openapi_client.TransactionsApi

All URIs are relative to *https://api.mywell.org/api/v2*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_transaction**](TransactionsApi.md#create_transaction) | **POST** /transaction | Create transaction
[**get_transaction**](TransactionsApi.md#get_transaction) | **GET** /transaction/{id} | Get transaction
[**refund_transaction**](TransactionsApi.md#refund_transaction) | **POST** /transaction/{id}/refund | Refund transaction
[**search_transactions**](TransactionsApi.md#search_transactions) | **POST** /transaction/search | Search transactions
[**void_transaction**](TransactionsApi.md#void_transaction) | **POST** /transaction/{id}/void | Void transaction


# **create_transaction**
> TransactionResponse create_transaction(x_authorization, x_organization, create_transaction_request)

Create transaction

Create a new transaction

### Example


```python
import openapi_client
from openapi_client.models.create_transaction_request import CreateTransactionRequest
from openapi_client.models.transaction_response import TransactionResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TransactionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    create_transaction_request = {"amount":5000,"customerId":"cmfl3x8be0001bkh9e2geb994","paymentMethodId":"d34n8ef0i47dk6gs9gog","campusId":"cmfl3x8be0001bkh9e2geb994","fundId":"fund123abc","description":"One-time donation","feesCovered":true} # CreateTransactionRequest | 

    try:
        # Create transaction
        api_response = api_instance.create_transaction(x_authorization, x_organization, create_transaction_request)
        print("The response of TransactionsApi->create_transaction:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransactionsApi->create_transaction: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **create_transaction_request** | [**CreateTransactionRequest**](CreateTransactionRequest.md)|  | 

### Return type

[**TransactionResponse**](TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Transaction created successfully |  -  |
**400** | Bad request |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_transaction**
> TransactionResponse get_transaction(x_authorization, x_organization, id)

Get transaction

Get transaction by ID

### Example


```python
import openapi_client
from openapi_client.models.transaction_response import TransactionResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TransactionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Transaction ID

    try:
        # Get transaction
        api_response = api_instance.get_transaction(x_authorization, x_organization, id)
        print("The response of TransactionsApi->get_transaction:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransactionsApi->get_transaction: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Transaction ID | 

### Return type

[**TransactionResponse**](TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Transaction details |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **refund_transaction**
> TransactionResponse refund_transaction(x_authorization, x_organization, id, body=body)

Refund transaction

Refund a transaction (full refund only)

### Example


```python
import openapi_client
from openapi_client.models.transaction_response import TransactionResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TransactionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Transaction ID
    body = None # object |  (optional)

    try:
        # Refund transaction
        api_response = api_instance.refund_transaction(x_authorization, x_organization, id, body=body)
        print("The response of TransactionsApi->refund_transaction:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransactionsApi->refund_transaction: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Transaction ID | 
 **body** | **object**|  | [optional] 

### Return type

[**TransactionResponse**](TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Transaction refunded successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **search_transactions**
> TransactionSearchResponse search_transactions(x_authorization, x_organization, transaction_search_request)

Search transactions

Search for transactions with optional filters and pagination

### Example


```python
import openapi_client
from openapi_client.models.transaction_search_request import TransactionSearchRequest
from openapi_client.models.transaction_search_response import TransactionSearchResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TransactionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    transaction_search_request = openapi_client.TransactionSearchRequest() # TransactionSearchRequest | 

    try:
        # Search transactions
        api_response = api_instance.search_transactions(x_authorization, x_organization, transaction_search_request)
        print("The response of TransactionsApi->search_transactions:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransactionsApi->search_transactions: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **transaction_search_request** | [**TransactionSearchRequest**](TransactionSearchRequest.md)|  | 

### Return type

[**TransactionSearchResponse**](TransactionSearchResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **void_transaction**
> TransactionResponse void_transaction(x_authorization, x_organization, id)

Void transaction

Void a transaction that hasn't been settled

### Example


```python
import openapi_client
from openapi_client.models.transaction_response import TransactionResponse
from openapi_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.mywell.org/api/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = openapi_client.Configuration(
    host = "https://api.mywell.org/api/v2"
)


# Enter a context with an instance of the API client
with openapi_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = openapi_client.TransactionsApi(api_client)
    x_authorization = 'Bearer YOUR_PLATFORM_API_ACCESS_TOKEN' # str | Bearer token for authentication (format: \"Bearer YOUR_TOKEN\")
    x_organization = 'cmfl3x8be0001bkh9e2geb994' # str | Organization ID that must match the integration's organization
    id = 'id_example' # str | Transaction ID

    try:
        # Void transaction
        api_response = api_instance.void_transaction(x_authorization, x_organization, id)
        print("The response of TransactionsApi->void_transaction:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling TransactionsApi->void_transaction: %s\n" % e)
```



### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **x_authorization** | **str**| Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | 
 **x_organization** | **str**| Organization ID that must match the integration&#39;s organization | 
 **id** | **str**| Transaction ID | 

### Return type

[**TransactionResponse**](TransactionResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Transaction voided successfully |  -  |
**400** | Bad request |  -  |
**404** | Resource not found |  -  |
**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

