# coding: utf-8

# flake8: noqa

"""
    MyWell Platform API

    # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# Define package exports
__all__ = [
    "AuthenticationApi",
    "CampusesApi",
    "CustomersApi",
    "FundsApi",
    "SubscriptionsApi",
    "TransactionsApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "AddPaymentMethodRequest",
    "Address",
    "AddressListResponse",
    "AmountRange",
    "BillingAddress",
    "Campus",
    "CampusSearchRequest",
    "CampusSearchResponse",
    "CreateAddressRequest",
    "CreateCustomerRequest",
    "CreateSubscriptionRequest",
    "CreateTransactionRequest",
    "CustomerResponse",
    "CustomerSearchRequest",
    "CustomerSearchResponse",
    "DateRange",
    "DeletePaymentMethod200Response",
    "DeletePaymentMethod200ResponseData",
    "ErrorResponse",
    "Fund",
    "FundAllocation",
    "FundSearchRequest",
    "FundSearchResponse",
    "Pagination",
    "PaymentMethod",
    "PaymentMethodInput",
    "PaymentMethodListResponse",
    "SubscriptionResponse",
    "SubscriptionSearchRequest",
    "SubscriptionSearchResponse",
    "TokenResponse",
    "TransactionResponse",
    "TransactionResponseCampus",
    "TransactionResponseCustomer",
    "TransactionResponseFundsInner",
    "TransactionSearchRequest",
    "TransactionSearchResponse",
    "UpdateAddressRequest",
    "UpdateCustomerRequest",
    "UpdateSubscriptionRequest",
]

# import apis into sdk package
from openapi_client.api.authentication_api import AuthenticationApi as AuthenticationApi
from openapi_client.api.campuses_api import CampusesApi as CampusesApi
from openapi_client.api.customers_api import CustomersApi as CustomersApi
from openapi_client.api.funds_api import FundsApi as FundsApi
from openapi_client.api.subscriptions_api import SubscriptionsApi as SubscriptionsApi
from openapi_client.api.transactions_api import TransactionsApi as TransactionsApi

# import ApiClient
from openapi_client.api_response import ApiResponse as ApiResponse
from openapi_client.api_client import ApiClient as ApiClient
from openapi_client.configuration import Configuration as Configuration
from openapi_client.exceptions import OpenApiException as OpenApiException
from openapi_client.exceptions import ApiTypeError as ApiTypeError
from openapi_client.exceptions import ApiValueError as ApiValueError
from openapi_client.exceptions import ApiKeyError as ApiKeyError
from openapi_client.exceptions import ApiAttributeError as ApiAttributeError
from openapi_client.exceptions import ApiException as ApiException

# import models into sdk package
from openapi_client.models.add_payment_method_request import AddPaymentMethodRequest as AddPaymentMethodRequest
from openapi_client.models.address import Address as Address
from openapi_client.models.address_list_response import AddressListResponse as AddressListResponse
from openapi_client.models.amount_range import AmountRange as AmountRange
from openapi_client.models.billing_address import BillingAddress as BillingAddress
from openapi_client.models.campus import Campus as Campus
from openapi_client.models.campus_search_request import CampusSearchRequest as CampusSearchRequest
from openapi_client.models.campus_search_response import CampusSearchResponse as CampusSearchResponse
from openapi_client.models.create_address_request import CreateAddressRequest as CreateAddressRequest
from openapi_client.models.create_customer_request import CreateCustomerRequest as CreateCustomerRequest
from openapi_client.models.create_subscription_request import CreateSubscriptionRequest as CreateSubscriptionRequest
from openapi_client.models.create_transaction_request import CreateTransactionRequest as CreateTransactionRequest
from openapi_client.models.customer_response import CustomerResponse as CustomerResponse
from openapi_client.models.customer_search_request import CustomerSearchRequest as CustomerSearchRequest
from openapi_client.models.customer_search_response import CustomerSearchResponse as CustomerSearchResponse
from openapi_client.models.date_range import DateRange as DateRange
from openapi_client.models.delete_payment_method200_response import DeletePaymentMethod200Response as DeletePaymentMethod200Response
from openapi_client.models.delete_payment_method200_response_data import DeletePaymentMethod200ResponseData as DeletePaymentMethod200ResponseData
from openapi_client.models.error_response import ErrorResponse as ErrorResponse
from openapi_client.models.fund import Fund as Fund
from openapi_client.models.fund_allocation import FundAllocation as FundAllocation
from openapi_client.models.fund_search_request import FundSearchRequest as FundSearchRequest
from openapi_client.models.fund_search_response import FundSearchResponse as FundSearchResponse
from openapi_client.models.pagination import Pagination as Pagination
from openapi_client.models.payment_method import PaymentMethod as PaymentMethod
from openapi_client.models.payment_method_input import PaymentMethodInput as PaymentMethodInput
from openapi_client.models.payment_method_list_response import PaymentMethodListResponse as PaymentMethodListResponse
from openapi_client.models.subscription_response import SubscriptionResponse as SubscriptionResponse
from openapi_client.models.subscription_search_request import SubscriptionSearchRequest as SubscriptionSearchRequest
from openapi_client.models.subscription_search_response import SubscriptionSearchResponse as SubscriptionSearchResponse
from openapi_client.models.token_response import TokenResponse as TokenResponse
from openapi_client.models.transaction_response import TransactionResponse as TransactionResponse
from openapi_client.models.transaction_response_campus import TransactionResponseCampus as TransactionResponseCampus
from openapi_client.models.transaction_response_customer import TransactionResponseCustomer as TransactionResponseCustomer
from openapi_client.models.transaction_response_funds_inner import TransactionResponseFundsInner as TransactionResponseFundsInner
from openapi_client.models.transaction_search_request import TransactionSearchRequest as TransactionSearchRequest
from openapi_client.models.transaction_search_response import TransactionSearchResponse as TransactionSearchResponse
from openapi_client.models.update_address_request import UpdateAddressRequest as UpdateAddressRequest
from openapi_client.models.update_customer_request import UpdateCustomerRequest as UpdateCustomerRequest
from openapi_client.models.update_subscription_request import UpdateSubscriptionRequest as UpdateSubscriptionRequest

