# coding: utf-8

"""
    MyWell Platform API

    # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from openapi_client.models.fund_allocation import FundAllocation
from typing import Optional, Set
from typing_extensions import Self

class CreateTransactionRequest(BaseModel):
    """
    CreateTransactionRequest
    """ # noqa: E501
    amount: Annotated[int, Field(strict=True, ge=1)] = Field(description="Amount in cents (minimum 1 cent = $0.01)")
    customer_id: StrictStr = Field(alias="customerId")
    payment_method_id: StrictStr = Field(description="Payment method database ID", alias="paymentMethodId")
    campus_id: Optional[StrictStr] = Field(default=None, description="Campus ID (defaults to oldest active campus with active funds if not provided)", alias="campusId")
    fund_id: Optional[StrictStr] = Field(default=None, description="Single fund ID (mutually exclusive with funds)", alias="fundId")
    funds: Optional[List[FundAllocation]] = Field(default=None, description="Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled)")
    description: Optional[StrictStr] = None
    fees_covered: Optional[StrictBool] = Field(default=False, description="Whether customer covers processing fees", alias="feesCovered")
    __properties: ClassVar[List[str]] = ["amount", "customerId", "paymentMethodId", "campusId", "fundId", "funds", "description", "feesCovered"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateTransactionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in funds (list)
        _items = []
        if self.funds:
            for _item_funds in self.funds:
                if _item_funds:
                    _items.append(_item_funds.to_dict())
            _dict['funds'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateTransactionRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "customerId": obj.get("customerId"),
            "paymentMethodId": obj.get("paymentMethodId"),
            "campusId": obj.get("campusId"),
            "fundId": obj.get("fundId"),
            "funds": [FundAllocation.from_dict(_item) for _item in obj["funds"]] if obj.get("funds") is not None else None,
            "description": obj.get("description"),
            "feesCovered": obj.get("feesCovered") if obj.get("feesCovered") is not None else False
        })
        return _obj


