# coding: utf-8

"""
    MyWell Platform API

    # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PaymentMethod(BaseModel):
    """
    PaymentMethod
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    last_four: Optional[StrictStr] = Field(default=None, alias="lastFour")
    expiry_month: Optional[StrictStr] = Field(default=None, alias="expiryMonth")
    expiry_year: Optional[StrictStr] = Field(default=None, alias="expiryYear")
    currency_type: Optional[StrictStr] = Field(default=None, alias="currencyType")
    credit_card_type: Optional[StrictStr] = Field(default=None, alias="creditCardType")
    __properties: ClassVar[List[str]] = ["id", "type", "lastFour", "expiryMonth", "expiryYear", "currencyType", "creditCardType"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['CARD', 'ACH']):
            raise ValueError("must be one of enum values ('CARD', 'ACH')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentMethod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if expiry_month (nullable) is None
        # and model_fields_set contains the field
        if self.expiry_month is None and "expiry_month" in self.model_fields_set:
            _dict['expiryMonth'] = None

        # set to None if expiry_year (nullable) is None
        # and model_fields_set contains the field
        if self.expiry_year is None and "expiry_year" in self.model_fields_set:
            _dict['expiryYear'] = None

        # set to None if currency_type (nullable) is None
        # and model_fields_set contains the field
        if self.currency_type is None and "currency_type" in self.model_fields_set:
            _dict['currencyType'] = None

        # set to None if credit_card_type (nullable) is None
        # and model_fields_set contains the field
        if self.credit_card_type is None and "credit_card_type" in self.model_fields_set:
            _dict['creditCardType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentMethod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "lastFour": obj.get("lastFour"),
            "expiryMonth": obj.get("expiryMonth"),
            "expiryYear": obj.get("expiryYear"),
            "currencyType": obj.get("currencyType"),
            "creditCardType": obj.get("creditCardType")
        })
        return _obj


