# coding: utf-8

"""
    MyWell Platform API

    # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration's organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration's organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes 

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from openapi_client.models.payment_method import PaymentMethod
from openapi_client.models.transaction_response_campus import TransactionResponseCampus
from openapi_client.models.transaction_response_customer import TransactionResponseCustomer
from openapi_client.models.transaction_response_funds_inner import TransactionResponseFundsInner
from typing import Optional, Set
from typing_extensions import Self

class TransactionResponse(BaseModel):
    """
    TransactionResponse
    """ # noqa: E501
    id: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    amount: Optional[StrictInt] = Field(default=None, description="Total amount in cents")
    gift_amount: Optional[StrictInt] = Field(default=None, description="Gift amount in cents (net to organization)", alias="giftAmount")
    fee_amount: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fee amount", alias="feeAmount")
    fee_rate: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Fee rate percentage", alias="feeRate")
    fees_covered: Optional[StrictBool] = Field(default=None, alias="feesCovered")
    status: Optional[StrictStr] = None
    customer_id: Optional[StrictStr] = Field(default=None, alias="customerId")
    subscription_id: Optional[StrictStr] = Field(default=None, alias="subscriptionId")
    description: Optional[StrictStr] = None
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    settled_at: Optional[datetime] = Field(default=None, alias="settledAt")
    customer: Optional[TransactionResponseCustomer] = None
    payment_method: Optional[PaymentMethod] = Field(default=None, alias="paymentMethod")
    campus: Optional[TransactionResponseCampus] = None
    funds: Optional[List[TransactionResponseFundsInner]] = None
    __properties: ClassVar[List[str]] = ["id", "type", "amount", "giftAmount", "feeAmount", "feeRate", "feesCovered", "status", "customerId", "subscriptionId", "description", "createdAt", "settledAt", "customer", "paymentMethod", "campus", "funds"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of customer
        if self.customer:
            _dict['customer'] = self.customer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_method
        if self.payment_method:
            _dict['paymentMethod'] = self.payment_method.to_dict()
        # override the default output from pydantic by calling `to_dict()` of campus
        if self.campus:
            _dict['campus'] = self.campus.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in funds (list)
        _items = []
        if self.funds:
            for _item_funds in self.funds:
                if _item_funds:
                    _items.append(_item_funds.to_dict())
            _dict['funds'] = _items
        # set to None if fee_amount (nullable) is None
        # and model_fields_set contains the field
        if self.fee_amount is None and "fee_amount" in self.model_fields_set:
            _dict['feeAmount'] = None

        # set to None if fee_rate (nullable) is None
        # and model_fields_set contains the field
        if self.fee_rate is None and "fee_rate" in self.model_fields_set:
            _dict['feeRate'] = None

        # set to None if subscription_id (nullable) is None
        # and model_fields_set contains the field
        if self.subscription_id is None and "subscription_id" in self.model_fields_set:
            _dict['subscriptionId'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if settled_at (nullable) is None
        # and model_fields_set contains the field
        if self.settled_at is None and "settled_at" in self.model_fields_set:
            _dict['settledAt'] = None

        # set to None if campus (nullable) is None
        # and model_fields_set contains the field
        if self.campus is None and "campus" in self.model_fields_set:
            _dict['campus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "amount": obj.get("amount"),
            "giftAmount": obj.get("giftAmount"),
            "feeAmount": obj.get("feeAmount"),
            "feeRate": obj.get("feeRate"),
            "feesCovered": obj.get("feesCovered"),
            "status": obj.get("status"),
            "customerId": obj.get("customerId"),
            "subscriptionId": obj.get("subscriptionId"),
            "description": obj.get("description"),
            "createdAt": obj.get("createdAt"),
            "settledAt": obj.get("settledAt"),
            "customer": TransactionResponseCustomer.from_dict(obj["customer"]) if obj.get("customer") is not None else None,
            "paymentMethod": PaymentMethod.from_dict(obj["paymentMethod"]) if obj.get("paymentMethod") is not None else None,
            "campus": TransactionResponseCampus.from_dict(obj["campus"]) if obj.get("campus") is not None else None,
            "funds": [TransactionResponseFundsInner.from_dict(_item) for _item in obj["funds"]] if obj.get("funds") is not None else None
        })
        return _obj


