## mywell-api-sdk@1.0.0

This generator creates TypeScript/JavaScript client that utilizes [axios](https://github.com/axios/axios). The generated Node module can be used in the following environments:

Environment
* Node.js
* Webpack
* Browserify

Language level
* ES5 - you must have a Promises/A+ library installed
* ES6

Module system
* CommonJS
* ES6 module system

It can be used in both TypeScript and JavaScript. In TypeScript, the definition will be automatically resolved via `package.json`. ([Reference](https://www.typescriptlang.org/docs/handbook/declaration-files/consumption.html))

### Building

To build and compile the typescript sources to javascript use:
```
npm install
npm run build
```

### Publishing

First build the package then run `npm publish`

### Consuming

navigate to the folder of your consuming project and run one of the following commands.

_published:_

```
npm install mywell-api-sdk@1.0.0 --save
```

_unPublished (not recommended):_

```
npm install PATH_TO_GENERATED_PACKAGE --save
```

### Documentation for API Endpoints

All URIs are relative to *https://api.mywell.org/api/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**useAccessToken**](docs/AuthenticationApi.md#useaccesstoken) | **GET** /auth/access | Initial token exchange
*AuthenticationApi* | [**useRefreshToken**](docs/AuthenticationApi.md#userefreshtoken) | **GET** /auth/refresh | Refresh token
*CampusesApi* | [**searchCampuses**](docs/CampusesApi.md#searchcampuses) | **POST** /campus/search | Search campuses
*CustomersApi* | [**addPaymentMethod**](docs/CustomersApi.md#addpaymentmethod) | **POST** /customer/{id}/paymentMethod | Add payment method
*CustomersApi* | [**createCustomer**](docs/CustomersApi.md#createcustomer) | **POST** /customer | Create customer
*CustomersApi* | [**createCustomerAddress**](docs/CustomersApi.md#createcustomeraddress) | **POST** /customer/{id}/address | Create customer address
*CustomersApi* | [**deleteCustomerAddress**](docs/CustomersApi.md#deletecustomeraddress) | **DELETE** /customer/{id}/address/{id2} | Delete customer address
*CustomersApi* | [**deletePaymentMethod**](docs/CustomersApi.md#deletepaymentmethod) | **DELETE** /customer/{id}/paymentMethod/{id2} | Delete payment method
*CustomersApi* | [**getCustomer**](docs/CustomersApi.md#getcustomer) | **GET** /customer/{id} | Get customer
*CustomersApi* | [**getCustomerAddresses**](docs/CustomersApi.md#getcustomeraddresses) | **GET** /customer/{id}/address | Get customer addresses
*CustomersApi* | [**getCustomerPaymentMethods**](docs/CustomersApi.md#getcustomerpaymentmethods) | **GET** /customer/{id}/paymentMethod | Get customer payment methods
*CustomersApi* | [**searchCustomers**](docs/CustomersApi.md#searchcustomers) | **POST** /customer/search | Search customers
*CustomersApi* | [**updateCustomer**](docs/CustomersApi.md#updatecustomer) | **PUT** /customer/{id} | Update customer
*FundsApi* | [**searchFunds**](docs/FundsApi.md#searchfunds) | **POST** /fund/search | Search funds
*SubscriptionsApi* | [**createSubscription**](docs/SubscriptionsApi.md#createsubscription) | **POST** /subscription | Create subscription
*SubscriptionsApi* | [**getSubscription**](docs/SubscriptionsApi.md#getsubscription) | **GET** /subscription/{id} | Get subscription
*SubscriptionsApi* | [**searchSubscriptions**](docs/SubscriptionsApi.md#searchsubscriptions) | **POST** /subscription/search | Search subscriptions
*SubscriptionsApi* | [**updateSubscription**](docs/SubscriptionsApi.md#updatesubscription) | **PUT** /subscription/{id} | Update subscription
*TransactionsApi* | [**createTransaction**](docs/TransactionsApi.md#createtransaction) | **POST** /transaction | Create transaction
*TransactionsApi* | [**getTransaction**](docs/TransactionsApi.md#gettransaction) | **GET** /transaction/{id} | Get transaction
*TransactionsApi* | [**refundTransaction**](docs/TransactionsApi.md#refundtransaction) | **POST** /transaction/{id}/refund | Refund transaction
*TransactionsApi* | [**searchTransactions**](docs/TransactionsApi.md#searchtransactions) | **POST** /transaction/search | Search transactions
*TransactionsApi* | [**voidTransaction**](docs/TransactionsApi.md#voidtransaction) | **POST** /transaction/{id}/void | Void transaction


### Documentation For Models

 - [AddPaymentMethodRequest](docs/AddPaymentMethodRequest.md)
 - [Address](docs/Address.md)
 - [AddressListResponse](docs/AddressListResponse.md)
 - [AmountRange](docs/AmountRange.md)
 - [BillingAddress](docs/BillingAddress.md)
 - [Campus](docs/Campus.md)
 - [CampusSearchRequest](docs/CampusSearchRequest.md)
 - [CampusSearchResponse](docs/CampusSearchResponse.md)
 - [CreateAddressRequest](docs/CreateAddressRequest.md)
 - [CreateCustomerRequest](docs/CreateCustomerRequest.md)
 - [CreateSubscriptionRequest](docs/CreateSubscriptionRequest.md)
 - [CreateTransactionRequest](docs/CreateTransactionRequest.md)
 - [CustomerResponse](docs/CustomerResponse.md)
 - [CustomerSearchRequest](docs/CustomerSearchRequest.md)
 - [CustomerSearchResponse](docs/CustomerSearchResponse.md)
 - [DateRange](docs/DateRange.md)
 - [DeletePaymentMethod200Response](docs/DeletePaymentMethod200Response.md)
 - [DeletePaymentMethod200ResponseData](docs/DeletePaymentMethod200ResponseData.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Fund](docs/Fund.md)
 - [FundAllocation](docs/FundAllocation.md)
 - [FundSearchRequest](docs/FundSearchRequest.md)
 - [FundSearchResponse](docs/FundSearchResponse.md)
 - [Pagination](docs/Pagination.md)
 - [PaymentMethod](docs/PaymentMethod.md)
 - [PaymentMethodInput](docs/PaymentMethodInput.md)
 - [PaymentMethodListResponse](docs/PaymentMethodListResponse.md)
 - [SubscriptionResponse](docs/SubscriptionResponse.md)
 - [SubscriptionSearchRequest](docs/SubscriptionSearchRequest.md)
 - [SubscriptionSearchResponse](docs/SubscriptionSearchResponse.md)
 - [TokenResponse](docs/TokenResponse.md)
 - [TransactionResponse](docs/TransactionResponse.md)
 - [TransactionResponseCampus](docs/TransactionResponseCampus.md)
 - [TransactionResponseCustomer](docs/TransactionResponseCustomer.md)
 - [TransactionResponseFundsInner](docs/TransactionResponseFundsInner.md)
 - [TransactionSearchRequest](docs/TransactionSearchRequest.md)
 - [TransactionSearchResponse](docs/TransactionSearchResponse.md)
 - [UpdateAddressRequest](docs/UpdateAddressRequest.md)
 - [UpdateCustomerRequest](docs/UpdateCustomerRequest.md)
 - [UpdateSubscriptionRequest](docs/UpdateSubscriptionRequest.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.

