/* tslint:disable */
/* eslint-disable */
/**
 * MyWell Platform API
 * # MyWell Platform API  This API provides comprehensive endpoints for payment processing, customer management, subscriptions, and transactions for the My Well platform.  ## Authentication  ### Token Exchange Endpoints  **Initial Token Exchange (`GET /api/v2/auth/access`):** - Requires: `ACCESS_TOKEN` header only - Returns: `organizationId` along with tokens  **Refresh Token Exchange (`GET /api/v2/auth/refresh`):** - Requires: `REFRESH_TOKEN` and `X-Organization` headers  ### API Requests  All other API requests require two headers: 1. **X-Authorization**: Bearer token for authentication 2. **X-Organization**: Organization ID that must match the integration\'s organization  ``` X-Authorization: Bearer YOUR_PLATFORM_API_TOKEN X-Organization: YOUR_ORGANIZATION_ID ```  The X-Organization header provides an additional layer of security by ensuring the organization ID matches the integration\'s organization.  ## Pagination Search endpoints support cursor-based pagination: 1. **First Request:** Send request without `cursor` 2. **Response:** Check `pagination.cursor` in response body for next page cursor 3. **Next Request:** Include `cursor` in request body 4. **Continue:** Repeat until `pagination.cursor` is not present (no next page)  **Limit Constraints:** - Default limit: 20 results per page - Maximum limit: 100 results per page - Minimum limit: Must be greater than 0 - Cursors expire after 5 minutes 
 *
 * The version of the OpenAPI document: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import type { Configuration } from './configuration';
import type { AxiosPromise, AxiosInstance, RawAxiosRequestConfig } from 'axios';
import globalAxios from 'axios';
// Some imports not used depending on template conditions
// @ts-ignore
import { DUMMY_BASE_URL, assertParamExists, setApiKeyToObject, setBasicAuthToObject, setBearerAuthToObject, setOAuthToObject, setSearchParams, serializeDataIfNeeded, toPathString, createRequestFunction } from './common';
import type { RequestArgs } from './base';
// @ts-ignore
import { BASE_PATH, COLLECTION_FORMATS, BaseAPI, RequiredError, operationServerMap } from './base';

export interface AddPaymentMethodRequest {
    /**
     * Payment token from tokenization service
     */
    'paymentMethodToken': string;
    /**
     * ID of existing address (mutually exclusive with billingAddress)
     */
    'billingAddressId'?: string;
    'billingAddress'?: BillingAddress;
}
export interface Address {
    'id'?: string;
    'street1'?: string;
    'street2'?: string | null;
    'city'?: string;
    'state'?: string;
    'postalCode'?: string;
    'country'?: string;
}
export interface AddressListResponse {
    'data'?: Array<Address>;
}
export interface AmountRange {
    /**
     * Minimum amount in cents
     */
    'min'?: number;
    /**
     * Maximum amount in cents
     */
    'max'?: number;
}
export interface BillingAddress {
    'street1': string;
    'street2'?: string;
    'city': string;
    'state': string;
    'postalCode': string;
    'country'?: string;
    'type'?: BillingAddressTypeEnum;
}

export const BillingAddressTypeEnum = {
    Home: 'HOME',
    Mailing: 'MAILING',
    Billing: 'BILLING',
    Work: 'WORK'
} as const;

export type BillingAddressTypeEnum = typeof BillingAddressTypeEnum[keyof typeof BillingAddressTypeEnum];

export interface Campus {
    'id'?: string;
    'name'?: string;
    'description'?: string | null;
    'isActive'?: boolean | null;
    'location'?: Address;
    'phoneNumber'?: string | null;
}
export interface CampusSearchRequest {
    /**
     * Filter by campus name (partial match, case-insensitive)
     */
    'name'?: string;
    /**
     * Filter by active status
     */
    'active'?: boolean;
    /**
     * Filter by phone number (partial match)
     */
    'phone'?: string;
    'limit'?: number;
    /**
     * Pagination cursor from pagination.cursor in previous response
     */
    'cursor'?: string;
}
export interface CampusSearchResponse {
    'data'?: Array<Campus>;
    'pagination'?: Pagination;
}
export interface CreateAddressRequest {
    'street1': string;
    'street2'?: string;
    'city': string;
    'state': string;
    'postalCode': string;
    'country'?: string;
    'type'?: CreateAddressRequestTypeEnum;
}

export const CreateAddressRequestTypeEnum = {
    Home: 'HOME',
    Mailing: 'MAILING',
    Billing: 'BILLING',
    Work: 'WORK'
} as const;

export type CreateAddressRequestTypeEnum = typeof CreateAddressRequestTypeEnum[keyof typeof CreateAddressRequestTypeEnum];

export interface CreateCustomerRequest {
    'kind'?: CreateCustomerRequestKindEnum;
    'description'?: string;
    'paymentMethod': PaymentMethodInput;
    'firstName': string;
    'lastName': string;
    'email': string;
    'phone': string;
    'billingAddress': BillingAddress;
    'clientType'?: CreateCustomerRequestClientTypeEnum;
}

export const CreateCustomerRequestKindEnum = {
    Donation: 'DONATION'
} as const;

export type CreateCustomerRequestKindEnum = typeof CreateCustomerRequestKindEnum[keyof typeof CreateCustomerRequestKindEnum];
export const CreateCustomerRequestClientTypeEnum = {
    Web: 'WEB',
    Ios: 'IOS',
    Android: 'ANDROID'
} as const;

export type CreateCustomerRequestClientTypeEnum = typeof CreateCustomerRequestClientTypeEnum[keyof typeof CreateCustomerRequestClientTypeEnum];

export interface CreateSubscriptionRequest {
    /**
     * Subscription amount in cents (minimum 100 cents = $1.00)
     */
    'amount': number;
    'frequency': CreateSubscriptionRequestFrequencyEnum;
    /**
     * Start date in YYYY-MM-DD format
     */
    'startDate': string;
    'customerId': string;
    /**
     * Payment method database ID
     */
    'paymentMethodId': string;
    /**
     * Campus ID (defaults to oldest active campus with active funds if not provided)
     */
    'campusId'?: string;
    /**
     * Single fund ID (mutually exclusive with funds)
     */
    'fundId'?: string;
    /**
     * Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled)
     */
    'funds'?: Array<FundAllocation>;
    'description'?: string;
    /**
     * Whether donor covers processing fees
     */
    'feesCovered'?: boolean;
}

export const CreateSubscriptionRequestFrequencyEnum = {
    OneTime: 'ONE_TIME',
    Weekly: 'WEEKLY',
    Monthly: 'MONTHLY',
    BiWeekly: 'BI_WEEKLY',
    FirstAndFifteenth: 'FIRST_AND_FIFTEENTH',
    Annual: 'ANNUAL'
} as const;

export type CreateSubscriptionRequestFrequencyEnum = typeof CreateSubscriptionRequestFrequencyEnum[keyof typeof CreateSubscriptionRequestFrequencyEnum];

export interface CreateTransactionRequest {
    /**
     * Amount in cents (minimum 1 cent = $0.01)
     */
    'amount': number;
    'customerId': string;
    /**
     * Payment method database ID
     */
    'paymentMethodId': string;
    /**
     * Campus ID (defaults to oldest active campus with active funds if not provided)
     */
    'campusId'?: string;
    /**
     * Single fund ID (mutually exclusive with funds)
     */
    'fundId'?: string;
    /**
     * Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled)
     */
    'funds'?: Array<FundAllocation>;
    'description'?: string;
    /**
     * Whether customer covers processing fees
     */
    'feesCovered'?: boolean;
}
export interface CustomerResponse {
    'id'?: string;
    'firstName'?: string;
    'lastName'?: string;
    'email'?: string;
    'createdAt'?: string;
    'defaultAddress'?: Address;
    'phoneNumber'?: string | null;
    'defaultPaymentMethod'?: PaymentMethod;
}
export interface CustomerSearchRequest {
    'id'?: string;
    'email'?: string;
    'firstName'?: string;
    'lastName'?: string;
    'phoneNumber'?: string;
    'createdAt'?: DateRange;
    'limit'?: number;
    /**
     * Pagination cursor from pagination.cursor in previous response
     */
    'cursor'?: string;
}
export interface CustomerSearchResponse {
    'data'?: Array<CustomerResponse>;
    'pagination'?: Pagination;
}
export interface DateRange {
    /**
     * Start date (ISO 8601)
     */
    'from'?: string;
    /**
     * End date (ISO 8601)
     */
    'to'?: string;
}
export interface DeletePaymentMethod200Response {
    'data'?: DeletePaymentMethod200ResponseData;
}
export interface DeletePaymentMethod200ResponseData {
    'success'?: boolean;
}
export interface ErrorResponse {
    /**
     * Error message
     */
    'error': string;
}
export interface Fund {
    'id'?: string;
    'name'?: string;
    'isActive'?: boolean | null;
    'isTaxDeductible'?: boolean | null;
    'isSchedulable'?: boolean | null;
}
export interface FundAllocation {
    /**
     * Fund ID
     */
    'id': string;
    /**
     * Amount in cents for this fund
     */
    'amount': number;
}
export interface FundSearchRequest {
    /**
     * Filter by fund name (partial match, case-insensitive)
     */
    'name'?: string;
    /**
     * Filter by active status
     */
    'active'?: boolean;
    /**
     * Filter by campus ID (returns only funds associated with the specified campus)
     */
    'campusId'?: string;
    'limit'?: number;
    /**
     * Pagination cursor from pagination.cursor in previous response
     */
    'cursor'?: string;
}
export interface FundSearchResponse {
    'data'?: Array<Fund>;
    'pagination'?: Pagination;
}
export interface Pagination {
    'totalRecords'?: number;
    'returned'?: number;
    'remaining'?: number;
    /**
     * Pagination cursor for next page (only present if there is a next page)
     */
    'cursor'?: string;
}
export interface PaymentMethod {
    'id'?: string;
    'type'?: PaymentMethodTypeEnum;
    'lastFour'?: string;
    'expiryMonth'?: string | null;
    'expiryYear'?: string | null;
    'currencyType'?: string | null;
    'creditCardType'?: string | null;
}

export const PaymentMethodTypeEnum = {
    Card: 'CARD',
    Ach: 'ACH'
} as const;

export type PaymentMethodTypeEnum = typeof PaymentMethodTypeEnum[keyof typeof PaymentMethodTypeEnum];

export interface PaymentMethodInput {
    /**
     * Payment token from tokenization service
     */
    'token': string;
    /**
     * Required for APPLE_PAY and GOOGLE_PAY, optional for CARD/ACH
     */
    'currencyType'?: PaymentMethodInputCurrencyTypeEnum;
}

export const PaymentMethodInputCurrencyTypeEnum = {
    ApplePay: 'APPLE_PAY',
    GooglePay: 'GOOGLE_PAY'
} as const;

export type PaymentMethodInputCurrencyTypeEnum = typeof PaymentMethodInputCurrencyTypeEnum[keyof typeof PaymentMethodInputCurrencyTypeEnum];

export interface PaymentMethodListResponse {
    'data'?: Array<PaymentMethod>;
}
export interface SubscriptionResponse {
    'id'?: string;
    'customerId'?: string;
    /**
     * Total amount in cents
     */
    'amount'?: number;
    /**
     * Gift amount in cents (net to organization)
     */
    'giftAmount'?: number;
    'feeAmount'?: number | null;
    'feeRate'?: number | null;
    'feesCovered'?: boolean;
    'frequency'?: string;
    'status'?: string;
    'startDate'?: string;
    'nextBillDate'?: string | null;
    'description'?: string | null;
    'createdAt'?: string;
    'updatedAt'?: string;
    'customer'?: TransactionResponseCustomer;
    'paymentMethod'?: PaymentMethod;
    'campus'?: TransactionResponseCampus | null;
    'funds'?: Array<TransactionResponseFundsInner>;
}
export interface SubscriptionSearchRequest {
    'subscriptionId'?: string;
    'customerId'?: string;
    'amount'?: AmountRange;
    'status'?: SubscriptionSearchRequestStatusEnum;
    'frequency'?: SubscriptionSearchRequestFrequencyEnum;
    'createdAt'?: DateRange;
    'startDate'?: DateRange;
    'nextBillDate'?: DateRange;
    'campusId'?: string;
    'fundId'?: string;
    'limit'?: number;
    /**
     * Pagination cursor from pagination.cursor in previous response
     */
    'cursor'?: string;
}

export const SubscriptionSearchRequestStatusEnum = {
    Active: 'ACTIVE',
    Paused: 'PAUSED',
    Canceled: 'CANCELED',
    Completed: 'COMPLETED',
    Failed: 'FAILED'
} as const;

export type SubscriptionSearchRequestStatusEnum = typeof SubscriptionSearchRequestStatusEnum[keyof typeof SubscriptionSearchRequestStatusEnum];
export const SubscriptionSearchRequestFrequencyEnum = {
    OneTime: 'ONE_TIME',
    Weekly: 'WEEKLY',
    Monthly: 'MONTHLY',
    BiWeekly: 'BI_WEEKLY',
    FirstAndFifteenth: 'FIRST_AND_FIFTEENTH',
    Annual: 'ANNUAL'
} as const;

export type SubscriptionSearchRequestFrequencyEnum = typeof SubscriptionSearchRequestFrequencyEnum[keyof typeof SubscriptionSearchRequestFrequencyEnum];

export interface SubscriptionSearchResponse {
    'data'?: Array<SubscriptionResponse>;
    'pagination'?: Pagination;
}
export interface TokenResponse {
    /**
     * Organization ID (only included in initial token exchange response)
     */
    'organizationId'?: string;
    'refresh_token'?: string;
    'refresh_expires'?: string;
    'api_token'?: string;
    'api_expires'?: string;
    'token_type'?: string;
}
export interface TransactionResponse {
    'id'?: string;
    'type'?: string;
    /**
     * Total amount in cents
     */
    'amount'?: number;
    /**
     * Gift amount in cents (net to organization)
     */
    'giftAmount'?: number;
    /**
     * Fee amount
     */
    'feeAmount'?: number | null;
    /**
     * Fee rate percentage
     */
    'feeRate'?: number | null;
    'feesCovered'?: boolean;
    'status'?: string;
    'customerId'?: string;
    'subscriptionId'?: string | null;
    'description'?: string | null;
    'createdAt'?: string;
    'settledAt'?: string | null;
    'customer'?: TransactionResponseCustomer;
    'paymentMethod'?: PaymentMethod;
    'campus'?: TransactionResponseCampus | null;
    'funds'?: Array<TransactionResponseFundsInner>;
}
export interface TransactionResponseCampus {
    'id'?: string;
    'name'?: string;
}
export interface TransactionResponseCustomer {
    'id'?: string;
    'firstName'?: string;
    'lastName'?: string;
    'email'?: string;
}
export interface TransactionResponseFundsInner {
    'id'?: string;
    'name'?: string;
    'amount'?: number;
    'giftAmount'?: number;
}
export interface TransactionSearchRequest {
    'transactionId'?: string;
    'customerId'?: string;
    'amount'?: AmountRange;
    'createdAt'?: DateRange;
    'settledAt'?: DateRange;
    'status'?: TransactionSearchRequestStatusEnum;
    'limit'?: number;
    /**
     * Pagination cursor from pagination.cursor in previous response
     */
    'cursor'?: string;
}

export const TransactionSearchRequestStatusEnum = {
    Settled: 'SETTLED',
    Pending: 'PENDING',
    Declined: 'DECLINED',
    Refunded: 'REFUNDED',
    Voided: 'VOIDED'
} as const;

export type TransactionSearchRequestStatusEnum = typeof TransactionSearchRequestStatusEnum[keyof typeof TransactionSearchRequestStatusEnum];

export interface TransactionSearchResponse {
    'data'?: Array<TransactionResponse>;
    'pagination'?: Pagination;
}
export interface UpdateAddressRequest {
    'street1'?: string;
    'street2'?: string;
    'city'?: string;
    'state'?: string;
    'postalCode'?: string;
    'country'?: string;
    'type'?: UpdateAddressRequestTypeEnum;
}

export const UpdateAddressRequestTypeEnum = {
    Home: 'HOME',
    Mailing: 'MAILING',
    Billing: 'BILLING',
    Work: 'WORK'
} as const;

export type UpdateAddressRequestTypeEnum = typeof UpdateAddressRequestTypeEnum[keyof typeof UpdateAddressRequestTypeEnum];

export interface UpdateCustomerRequest {
    'firstName'?: string;
    'lastName'?: string;
    'email'?: string;
    'phoneNumber'?: string;
}
export interface UpdateSubscriptionRequest {
    /**
     * Subscription amount in cents (giftAmount - what donor wants to give)
     */
    'amount'?: number;
    'frequency'?: UpdateSubscriptionRequestFrequencyEnum;
    'startDate'?: string;
    /**
     * Payment method database ID
     */
    'paymentMethodId'?: string;
    'description'?: string;
    'status'?: UpdateSubscriptionRequestStatusEnum;
    'nextBillDate'?: string;
    'feesCovered'?: boolean;
}

export const UpdateSubscriptionRequestFrequencyEnum = {
    OneTime: 'ONE_TIME',
    Weekly: 'WEEKLY',
    Monthly: 'MONTHLY',
    BiWeekly: 'BI_WEEKLY',
    FirstAndFifteenth: 'FIRST_AND_FIFTEENTH',
    Annual: 'ANNUAL'
} as const;

export type UpdateSubscriptionRequestFrequencyEnum = typeof UpdateSubscriptionRequestFrequencyEnum[keyof typeof UpdateSubscriptionRequestFrequencyEnum];
export const UpdateSubscriptionRequestStatusEnum = {
    Active: 'ACTIVE',
    Paused: 'PAUSED',
    Canceled: 'CANCELED'
} as const;

export type UpdateSubscriptionRequestStatusEnum = typeof UpdateSubscriptionRequestStatusEnum[keyof typeof UpdateSubscriptionRequestStatusEnum];


/**
 * AuthenticationApi - axios parameter creator
 */
export const AuthenticationApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * One-time use endpoint for initial token exchange. Only works when integration is disabled. After successful use, the integration is enabled and this endpoint becomes unusable.  **Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response. 
         * @summary Initial token exchange
         * @param {string} aCCESSTOKEN Access token from integration creation
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        useAccessToken: async (aCCESSTOKEN: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'aCCESSTOKEN' is not null or undefined
            assertParamExists('useAccessToken', 'aCCESSTOKEN', aCCESSTOKEN)
            const localVarPath = `/auth/access`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (aCCESSTOKEN != null) {
                localVarHeaderParameter['ACCESS_TOKEN'] = String(aCCESSTOKEN);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get new tokens using refresh token
         * @summary Refresh token
         * @param {string} rEFRESHTOKEN Refresh token from previous token exchange
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        useRefreshToken: async (rEFRESHTOKEN: string, xOrganization: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'rEFRESHTOKEN' is not null or undefined
            assertParamExists('useRefreshToken', 'rEFRESHTOKEN', rEFRESHTOKEN)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('useRefreshToken', 'xOrganization', xOrganization)
            const localVarPath = `/auth/refresh`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (rEFRESHTOKEN != null) {
                localVarHeaderParameter['REFRESH_TOKEN'] = String(rEFRESHTOKEN);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * AuthenticationApi - functional programming interface
 */
export const AuthenticationApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = AuthenticationApiAxiosParamCreator(configuration)
    return {
        /**
         * One-time use endpoint for initial token exchange. Only works when integration is disabled. After successful use, the integration is enabled and this endpoint becomes unusable.  **Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response. 
         * @summary Initial token exchange
         * @param {string} aCCESSTOKEN Access token from integration creation
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async useAccessToken(aCCESSTOKEN: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TokenResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.useAccessToken(aCCESSTOKEN, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['AuthenticationApi.useAccessToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get new tokens using refresh token
         * @summary Refresh token
         * @param {string} rEFRESHTOKEN Refresh token from previous token exchange
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async useRefreshToken(rEFRESHTOKEN: string, xOrganization: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TokenResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.useRefreshToken(rEFRESHTOKEN, xOrganization, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['AuthenticationApi.useRefreshToken']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * AuthenticationApi - factory interface
 */
export const AuthenticationApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = AuthenticationApiFp(configuration)
    return {
        /**
         * One-time use endpoint for initial token exchange. Only works when integration is disabled. After successful use, the integration is enabled and this endpoint becomes unusable.  **Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response. 
         * @summary Initial token exchange
         * @param {string} aCCESSTOKEN Access token from integration creation
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        useAccessToken(aCCESSTOKEN: string, options?: RawAxiosRequestConfig): AxiosPromise<TokenResponse> {
            return localVarFp.useAccessToken(aCCESSTOKEN, options).then((request) => request(axios, basePath));
        },
        /**
         * Get new tokens using refresh token
         * @summary Refresh token
         * @param {string} rEFRESHTOKEN Refresh token from previous token exchange
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        useRefreshToken(rEFRESHTOKEN: string, xOrganization: string, options?: RawAxiosRequestConfig): AxiosPromise<TokenResponse> {
            return localVarFp.useRefreshToken(rEFRESHTOKEN, xOrganization, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * AuthenticationApi - object-oriented interface
 */
export class AuthenticationApi extends BaseAPI {
    /**
     * One-time use endpoint for initial token exchange. Only works when integration is disabled. After successful use, the integration is enabled and this endpoint becomes unusable.  **Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response. 
     * @summary Initial token exchange
     * @param {string} aCCESSTOKEN Access token from integration creation
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public useAccessToken(aCCESSTOKEN: string, options?: RawAxiosRequestConfig) {
        return AuthenticationApiFp(this.configuration).useAccessToken(aCCESSTOKEN, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get new tokens using refresh token
     * @summary Refresh token
     * @param {string} rEFRESHTOKEN Refresh token from previous token exchange
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public useRefreshToken(rEFRESHTOKEN: string, xOrganization: string, options?: RawAxiosRequestConfig) {
        return AuthenticationApiFp(this.configuration).useRefreshToken(rEFRESHTOKEN, xOrganization, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * CampusesApi - axios parameter creator
 */
export const CampusesApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Search for campuses with optional filters and pagination
         * @summary Search campuses
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CampusSearchRequest} campusSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchCampuses: async (xAuthorization: string, xOrganization: string, campusSearchRequest: CampusSearchRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('searchCampuses', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('searchCampuses', 'xOrganization', xOrganization)
            // verify required parameter 'campusSearchRequest' is not null or undefined
            assertParamExists('searchCampuses', 'campusSearchRequest', campusSearchRequest)
            const localVarPath = `/campus/search`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(campusSearchRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * CampusesApi - functional programming interface
 */
export const CampusesApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = CampusesApiAxiosParamCreator(configuration)
    return {
        /**
         * Search for campuses with optional filters and pagination
         * @summary Search campuses
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CampusSearchRequest} campusSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async searchCampuses(xAuthorization: string, xOrganization: string, campusSearchRequest: CampusSearchRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CampusSearchResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.searchCampuses(xAuthorization, xOrganization, campusSearchRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CampusesApi.searchCampuses']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * CampusesApi - factory interface
 */
export const CampusesApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = CampusesApiFp(configuration)
    return {
        /**
         * Search for campuses with optional filters and pagination
         * @summary Search campuses
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CampusSearchRequest} campusSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchCampuses(xAuthorization: string, xOrganization: string, campusSearchRequest: CampusSearchRequest, options?: RawAxiosRequestConfig): AxiosPromise<CampusSearchResponse> {
            return localVarFp.searchCampuses(xAuthorization, xOrganization, campusSearchRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * CampusesApi - object-oriented interface
 */
export class CampusesApi extends BaseAPI {
    /**
     * Search for campuses with optional filters and pagination
     * @summary Search campuses
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {CampusSearchRequest} campusSearchRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public searchCampuses(xAuthorization: string, xOrganization: string, campusSearchRequest: CampusSearchRequest, options?: RawAxiosRequestConfig) {
        return CampusesApiFp(this.configuration).searchCampuses(xAuthorization, xOrganization, campusSearchRequest, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * CustomersApi - axios parameter creator
 */
export const CustomersApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Add a payment method to a customer
         * @summary Add payment method
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {AddPaymentMethodRequest} addPaymentMethodRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        addPaymentMethod: async (xAuthorization: string, xOrganization: string, id: string, addPaymentMethodRequest: AddPaymentMethodRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('addPaymentMethod', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('addPaymentMethod', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('addPaymentMethod', 'id', id)
            // verify required parameter 'addPaymentMethodRequest' is not null or undefined
            assertParamExists('addPaymentMethod', 'addPaymentMethodRequest', addPaymentMethodRequest)
            const localVarPath = `/customer/{id}/paymentMethod`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(addPaymentMethodRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Create a new customer with payment method
         * @summary Create customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateCustomerRequest} createCustomerRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createCustomer: async (xAuthorization: string, xOrganization: string, createCustomerRequest: CreateCustomerRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('createCustomer', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('createCustomer', 'xOrganization', xOrganization)
            // verify required parameter 'createCustomerRequest' is not null or undefined
            assertParamExists('createCustomer', 'createCustomerRequest', createCustomerRequest)
            const localVarPath = `/customer`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(createCustomerRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Create a new address for a customer
         * @summary Create customer address
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {CreateAddressRequest} createAddressRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createCustomerAddress: async (xAuthorization: string, xOrganization: string, id: string, createAddressRequest: CreateAddressRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('createCustomerAddress', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('createCustomerAddress', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('createCustomerAddress', 'id', id)
            // verify required parameter 'createAddressRequest' is not null or undefined
            assertParamExists('createCustomerAddress', 'createAddressRequest', createAddressRequest)
            const localVarPath = `/customer/{id}/address`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(createAddressRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete an address from a customer
         * @summary Delete customer address
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {string} id2 Address ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteCustomerAddress: async (xAuthorization: string, xOrganization: string, id: string, id2: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('deleteCustomerAddress', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('deleteCustomerAddress', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('deleteCustomerAddress', 'id', id)
            // verify required parameter 'id2' is not null or undefined
            assertParamExists('deleteCustomerAddress', 'id2', id2)
            const localVarPath = `/customer/{id}/address/{id2}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)))
                .replace(`{${"id2"}}`, encodeURIComponent(String(id2)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Delete a payment method from a customer
         * @summary Delete payment method
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {string} id2 Payment method ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePaymentMethod: async (xAuthorization: string, xOrganization: string, id: string, id2: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('deletePaymentMethod', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('deletePaymentMethod', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('deletePaymentMethod', 'id', id)
            // verify required parameter 'id2' is not null or undefined
            assertParamExists('deletePaymentMethod', 'id2', id2)
            const localVarPath = `/customer/{id}/paymentMethod/{id2}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)))
                .replace(`{${"id2"}}`, encodeURIComponent(String(id2)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'DELETE', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get customer by ID
         * @summary Get customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCustomer: async (xAuthorization: string, xOrganization: string, id: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('getCustomer', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('getCustomer', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('getCustomer', 'id', id)
            const localVarPath = `/customer/{id}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get all addresses for a customer
         * @summary Get customer addresses
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCustomerAddresses: async (xAuthorization: string, xOrganization: string, id: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('getCustomerAddresses', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('getCustomerAddresses', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('getCustomerAddresses', 'id', id)
            const localVarPath = `/customer/{id}/address`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get all payment methods for a customer
         * @summary Get customer payment methods
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCustomerPaymentMethods: async (xAuthorization: string, xOrganization: string, id: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('getCustomerPaymentMethods', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('getCustomerPaymentMethods', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('getCustomerPaymentMethods', 'id', id)
            const localVarPath = `/customer/{id}/paymentMethod`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Search for customers with optional filters and pagination
         * @summary Search customers
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CustomerSearchRequest} customerSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchCustomers: async (xAuthorization: string, xOrganization: string, customerSearchRequest: CustomerSearchRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('searchCustomers', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('searchCustomers', 'xOrganization', xOrganization)
            // verify required parameter 'customerSearchRequest' is not null or undefined
            assertParamExists('searchCustomers', 'customerSearchRequest', customerSearchRequest)
            const localVarPath = `/customer/search`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(customerSearchRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update customer information
         * @summary Update customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {UpdateCustomerRequest} updateCustomerRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateCustomer: async (xAuthorization: string, xOrganization: string, id: string, updateCustomerRequest: UpdateCustomerRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('updateCustomer', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('updateCustomer', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('updateCustomer', 'id', id)
            // verify required parameter 'updateCustomerRequest' is not null or undefined
            assertParamExists('updateCustomer', 'updateCustomerRequest', updateCustomerRequest)
            const localVarPath = `/customer/{id}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(updateCustomerRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * CustomersApi - functional programming interface
 */
export const CustomersApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = CustomersApiAxiosParamCreator(configuration)
    return {
        /**
         * Add a payment method to a customer
         * @summary Add payment method
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {AddPaymentMethodRequest} addPaymentMethodRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async addPaymentMethod(xAuthorization: string, xOrganization: string, id: string, addPaymentMethodRequest: AddPaymentMethodRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PaymentMethod>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.addPaymentMethod(xAuthorization, xOrganization, id, addPaymentMethodRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.addPaymentMethod']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Create a new customer with payment method
         * @summary Create customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateCustomerRequest} createCustomerRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createCustomer(xAuthorization: string, xOrganization: string, createCustomerRequest: CreateCustomerRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CustomerResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createCustomer(xAuthorization, xOrganization, createCustomerRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.createCustomer']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Create a new address for a customer
         * @summary Create customer address
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {CreateAddressRequest} createAddressRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createCustomerAddress(xAuthorization: string, xOrganization: string, id: string, createAddressRequest: CreateAddressRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<Address>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createCustomerAddress(xAuthorization, xOrganization, id, createAddressRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.createCustomerAddress']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete an address from a customer
         * @summary Delete customer address
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {string} id2 Address ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deleteCustomerAddress(xAuthorization: string, xOrganization: string, id: string, id2: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<DeletePaymentMethod200Response>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deleteCustomerAddress(xAuthorization, xOrganization, id, id2, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.deleteCustomerAddress']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Delete a payment method from a customer
         * @summary Delete payment method
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {string} id2 Payment method ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async deletePaymentMethod(xAuthorization: string, xOrganization: string, id: string, id2: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<DeletePaymentMethod200Response>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.deletePaymentMethod(xAuthorization, xOrganization, id, id2, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.deletePaymentMethod']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get customer by ID
         * @summary Get customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getCustomer(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CustomerResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getCustomer(xAuthorization, xOrganization, id, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.getCustomer']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get all addresses for a customer
         * @summary Get customer addresses
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getCustomerAddresses(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<AddressListResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getCustomerAddresses(xAuthorization, xOrganization, id, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.getCustomerAddresses']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get all payment methods for a customer
         * @summary Get customer payment methods
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getCustomerPaymentMethods(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<PaymentMethodListResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getCustomerPaymentMethods(xAuthorization, xOrganization, id, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.getCustomerPaymentMethods']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Search for customers with optional filters and pagination
         * @summary Search customers
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CustomerSearchRequest} customerSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async searchCustomers(xAuthorization: string, xOrganization: string, customerSearchRequest: CustomerSearchRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CustomerSearchResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.searchCustomers(xAuthorization, xOrganization, customerSearchRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.searchCustomers']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update customer information
         * @summary Update customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {UpdateCustomerRequest} updateCustomerRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateCustomer(xAuthorization: string, xOrganization: string, id: string, updateCustomerRequest: UpdateCustomerRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<CustomerResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateCustomer(xAuthorization, xOrganization, id, updateCustomerRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['CustomersApi.updateCustomer']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * CustomersApi - factory interface
 */
export const CustomersApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = CustomersApiFp(configuration)
    return {
        /**
         * Add a payment method to a customer
         * @summary Add payment method
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {AddPaymentMethodRequest} addPaymentMethodRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        addPaymentMethod(xAuthorization: string, xOrganization: string, id: string, addPaymentMethodRequest: AddPaymentMethodRequest, options?: RawAxiosRequestConfig): AxiosPromise<PaymentMethod> {
            return localVarFp.addPaymentMethod(xAuthorization, xOrganization, id, addPaymentMethodRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Create a new customer with payment method
         * @summary Create customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateCustomerRequest} createCustomerRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createCustomer(xAuthorization: string, xOrganization: string, createCustomerRequest: CreateCustomerRequest, options?: RawAxiosRequestConfig): AxiosPromise<CustomerResponse> {
            return localVarFp.createCustomer(xAuthorization, xOrganization, createCustomerRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Create a new address for a customer
         * @summary Create customer address
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {CreateAddressRequest} createAddressRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createCustomerAddress(xAuthorization: string, xOrganization: string, id: string, createAddressRequest: CreateAddressRequest, options?: RawAxiosRequestConfig): AxiosPromise<Address> {
            return localVarFp.createCustomerAddress(xAuthorization, xOrganization, id, createAddressRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete an address from a customer
         * @summary Delete customer address
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {string} id2 Address ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deleteCustomerAddress(xAuthorization: string, xOrganization: string, id: string, id2: string, options?: RawAxiosRequestConfig): AxiosPromise<DeletePaymentMethod200Response> {
            return localVarFp.deleteCustomerAddress(xAuthorization, xOrganization, id, id2, options).then((request) => request(axios, basePath));
        },
        /**
         * Delete a payment method from a customer
         * @summary Delete payment method
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {string} id2 Payment method ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        deletePaymentMethod(xAuthorization: string, xOrganization: string, id: string, id2: string, options?: RawAxiosRequestConfig): AxiosPromise<DeletePaymentMethod200Response> {
            return localVarFp.deletePaymentMethod(xAuthorization, xOrganization, id, id2, options).then((request) => request(axios, basePath));
        },
        /**
         * Get customer by ID
         * @summary Get customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCustomer(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): AxiosPromise<CustomerResponse> {
            return localVarFp.getCustomer(xAuthorization, xOrganization, id, options).then((request) => request(axios, basePath));
        },
        /**
         * Get all addresses for a customer
         * @summary Get customer addresses
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCustomerAddresses(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): AxiosPromise<AddressListResponse> {
            return localVarFp.getCustomerAddresses(xAuthorization, xOrganization, id, options).then((request) => request(axios, basePath));
        },
        /**
         * Get all payment methods for a customer
         * @summary Get customer payment methods
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getCustomerPaymentMethods(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): AxiosPromise<PaymentMethodListResponse> {
            return localVarFp.getCustomerPaymentMethods(xAuthorization, xOrganization, id, options).then((request) => request(axios, basePath));
        },
        /**
         * Search for customers with optional filters and pagination
         * @summary Search customers
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CustomerSearchRequest} customerSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchCustomers(xAuthorization: string, xOrganization: string, customerSearchRequest: CustomerSearchRequest, options?: RawAxiosRequestConfig): AxiosPromise<CustomerSearchResponse> {
            return localVarFp.searchCustomers(xAuthorization, xOrganization, customerSearchRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Update customer information
         * @summary Update customer
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Customer ID
         * @param {UpdateCustomerRequest} updateCustomerRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateCustomer(xAuthorization: string, xOrganization: string, id: string, updateCustomerRequest: UpdateCustomerRequest, options?: RawAxiosRequestConfig): AxiosPromise<CustomerResponse> {
            return localVarFp.updateCustomer(xAuthorization, xOrganization, id, updateCustomerRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * CustomersApi - object-oriented interface
 */
export class CustomersApi extends BaseAPI {
    /**
     * Add a payment method to a customer
     * @summary Add payment method
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {AddPaymentMethodRequest} addPaymentMethodRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public addPaymentMethod(xAuthorization: string, xOrganization: string, id: string, addPaymentMethodRequest: AddPaymentMethodRequest, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).addPaymentMethod(xAuthorization, xOrganization, id, addPaymentMethodRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Create a new customer with payment method
     * @summary Create customer
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {CreateCustomerRequest} createCustomerRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public createCustomer(xAuthorization: string, xOrganization: string, createCustomerRequest: CreateCustomerRequest, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).createCustomer(xAuthorization, xOrganization, createCustomerRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Create a new address for a customer
     * @summary Create customer address
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {CreateAddressRequest} createAddressRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public createCustomerAddress(xAuthorization: string, xOrganization: string, id: string, createAddressRequest: CreateAddressRequest, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).createCustomerAddress(xAuthorization, xOrganization, id, createAddressRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete an address from a customer
     * @summary Delete customer address
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {string} id2 Address ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public deleteCustomerAddress(xAuthorization: string, xOrganization: string, id: string, id2: string, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).deleteCustomerAddress(xAuthorization, xOrganization, id, id2, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Delete a payment method from a customer
     * @summary Delete payment method
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {string} id2 Payment method ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public deletePaymentMethod(xAuthorization: string, xOrganization: string, id: string, id2: string, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).deletePaymentMethod(xAuthorization, xOrganization, id, id2, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get customer by ID
     * @summary Get customer
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getCustomer(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).getCustomer(xAuthorization, xOrganization, id, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get all addresses for a customer
     * @summary Get customer addresses
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getCustomerAddresses(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).getCustomerAddresses(xAuthorization, xOrganization, id, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get all payment methods for a customer
     * @summary Get customer payment methods
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getCustomerPaymentMethods(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).getCustomerPaymentMethods(xAuthorization, xOrganization, id, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Search for customers with optional filters and pagination
     * @summary Search customers
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {CustomerSearchRequest} customerSearchRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public searchCustomers(xAuthorization: string, xOrganization: string, customerSearchRequest: CustomerSearchRequest, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).searchCustomers(xAuthorization, xOrganization, customerSearchRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update customer information
     * @summary Update customer
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Customer ID
     * @param {UpdateCustomerRequest} updateCustomerRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public updateCustomer(xAuthorization: string, xOrganization: string, id: string, updateCustomerRequest: UpdateCustomerRequest, options?: RawAxiosRequestConfig) {
        return CustomersApiFp(this.configuration).updateCustomer(xAuthorization, xOrganization, id, updateCustomerRequest, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * FundsApi - axios parameter creator
 */
export const FundsApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Search for funds with optional filters and pagination
         * @summary Search funds
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {FundSearchRequest} fundSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchFunds: async (xAuthorization: string, xOrganization: string, fundSearchRequest: FundSearchRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('searchFunds', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('searchFunds', 'xOrganization', xOrganization)
            // verify required parameter 'fundSearchRequest' is not null or undefined
            assertParamExists('searchFunds', 'fundSearchRequest', fundSearchRequest)
            const localVarPath = `/fund/search`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(fundSearchRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * FundsApi - functional programming interface
 */
export const FundsApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = FundsApiAxiosParamCreator(configuration)
    return {
        /**
         * Search for funds with optional filters and pagination
         * @summary Search funds
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {FundSearchRequest} fundSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async searchFunds(xAuthorization: string, xOrganization: string, fundSearchRequest: FundSearchRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<FundSearchResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.searchFunds(xAuthorization, xOrganization, fundSearchRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['FundsApi.searchFunds']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * FundsApi - factory interface
 */
export const FundsApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = FundsApiFp(configuration)
    return {
        /**
         * Search for funds with optional filters and pagination
         * @summary Search funds
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {FundSearchRequest} fundSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchFunds(xAuthorization: string, xOrganization: string, fundSearchRequest: FundSearchRequest, options?: RawAxiosRequestConfig): AxiosPromise<FundSearchResponse> {
            return localVarFp.searchFunds(xAuthorization, xOrganization, fundSearchRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * FundsApi - object-oriented interface
 */
export class FundsApi extends BaseAPI {
    /**
     * Search for funds with optional filters and pagination
     * @summary Search funds
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {FundSearchRequest} fundSearchRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public searchFunds(xAuthorization: string, xOrganization: string, fundSearchRequest: FundSearchRequest, options?: RawAxiosRequestConfig) {
        return FundsApiFp(this.configuration).searchFunds(xAuthorization, xOrganization, fundSearchRequest, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * SubscriptionsApi - axios parameter creator
 */
export const SubscriptionsApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create a new subscription
         * @summary Create subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateSubscriptionRequest} createSubscriptionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createSubscription: async (xAuthorization: string, xOrganization: string, createSubscriptionRequest: CreateSubscriptionRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('createSubscription', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('createSubscription', 'xOrganization', xOrganization)
            // verify required parameter 'createSubscriptionRequest' is not null or undefined
            assertParamExists('createSubscription', 'createSubscriptionRequest', createSubscriptionRequest)
            const localVarPath = `/subscription`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(createSubscriptionRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get subscription by ID
         * @summary Get subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Subscription ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSubscription: async (xAuthorization: string, xOrganization: string, id: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('getSubscription', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('getSubscription', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('getSubscription', 'id', id)
            const localVarPath = `/subscription/{id}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Search for subscriptions with optional filters and pagination
         * @summary Search subscriptions
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {SubscriptionSearchRequest} subscriptionSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchSubscriptions: async (xAuthorization: string, xOrganization: string, subscriptionSearchRequest: SubscriptionSearchRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('searchSubscriptions', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('searchSubscriptions', 'xOrganization', xOrganization)
            // verify required parameter 'subscriptionSearchRequest' is not null or undefined
            assertParamExists('searchSubscriptions', 'subscriptionSearchRequest', subscriptionSearchRequest)
            const localVarPath = `/subscription/search`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(subscriptionSearchRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Update subscription details
         * @summary Update subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Subscription ID
         * @param {UpdateSubscriptionRequest} updateSubscriptionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSubscription: async (xAuthorization: string, xOrganization: string, id: string, updateSubscriptionRequest: UpdateSubscriptionRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('updateSubscription', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('updateSubscription', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('updateSubscription', 'id', id)
            // verify required parameter 'updateSubscriptionRequest' is not null or undefined
            assertParamExists('updateSubscription', 'updateSubscriptionRequest', updateSubscriptionRequest)
            const localVarPath = `/subscription/{id}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'PUT', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(updateSubscriptionRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * SubscriptionsApi - functional programming interface
 */
export const SubscriptionsApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = SubscriptionsApiAxiosParamCreator(configuration)
    return {
        /**
         * Create a new subscription
         * @summary Create subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateSubscriptionRequest} createSubscriptionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createSubscription(xAuthorization: string, xOrganization: string, createSubscriptionRequest: CreateSubscriptionRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SubscriptionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createSubscription(xAuthorization, xOrganization, createSubscriptionRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionsApi.createSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get subscription by ID
         * @summary Get subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Subscription ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getSubscription(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SubscriptionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getSubscription(xAuthorization, xOrganization, id, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionsApi.getSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Search for subscriptions with optional filters and pagination
         * @summary Search subscriptions
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {SubscriptionSearchRequest} subscriptionSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async searchSubscriptions(xAuthorization: string, xOrganization: string, subscriptionSearchRequest: SubscriptionSearchRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SubscriptionSearchResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.searchSubscriptions(xAuthorization, xOrganization, subscriptionSearchRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionsApi.searchSubscriptions']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Update subscription details
         * @summary Update subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Subscription ID
         * @param {UpdateSubscriptionRequest} updateSubscriptionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async updateSubscription(xAuthorization: string, xOrganization: string, id: string, updateSubscriptionRequest: UpdateSubscriptionRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<SubscriptionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.updateSubscription(xAuthorization, xOrganization, id, updateSubscriptionRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['SubscriptionsApi.updateSubscription']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * SubscriptionsApi - factory interface
 */
export const SubscriptionsApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = SubscriptionsApiFp(configuration)
    return {
        /**
         * Create a new subscription
         * @summary Create subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateSubscriptionRequest} createSubscriptionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createSubscription(xAuthorization: string, xOrganization: string, createSubscriptionRequest: CreateSubscriptionRequest, options?: RawAxiosRequestConfig): AxiosPromise<SubscriptionResponse> {
            return localVarFp.createSubscription(xAuthorization, xOrganization, createSubscriptionRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Get subscription by ID
         * @summary Get subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Subscription ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getSubscription(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): AxiosPromise<SubscriptionResponse> {
            return localVarFp.getSubscription(xAuthorization, xOrganization, id, options).then((request) => request(axios, basePath));
        },
        /**
         * Search for subscriptions with optional filters and pagination
         * @summary Search subscriptions
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {SubscriptionSearchRequest} subscriptionSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchSubscriptions(xAuthorization: string, xOrganization: string, subscriptionSearchRequest: SubscriptionSearchRequest, options?: RawAxiosRequestConfig): AxiosPromise<SubscriptionSearchResponse> {
            return localVarFp.searchSubscriptions(xAuthorization, xOrganization, subscriptionSearchRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Update subscription details
         * @summary Update subscription
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Subscription ID
         * @param {UpdateSubscriptionRequest} updateSubscriptionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        updateSubscription(xAuthorization: string, xOrganization: string, id: string, updateSubscriptionRequest: UpdateSubscriptionRequest, options?: RawAxiosRequestConfig): AxiosPromise<SubscriptionResponse> {
            return localVarFp.updateSubscription(xAuthorization, xOrganization, id, updateSubscriptionRequest, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * SubscriptionsApi - object-oriented interface
 */
export class SubscriptionsApi extends BaseAPI {
    /**
     * Create a new subscription
     * @summary Create subscription
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {CreateSubscriptionRequest} createSubscriptionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public createSubscription(xAuthorization: string, xOrganization: string, createSubscriptionRequest: CreateSubscriptionRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionsApiFp(this.configuration).createSubscription(xAuthorization, xOrganization, createSubscriptionRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get subscription by ID
     * @summary Get subscription
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Subscription ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getSubscription(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig) {
        return SubscriptionsApiFp(this.configuration).getSubscription(xAuthorization, xOrganization, id, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Search for subscriptions with optional filters and pagination
     * @summary Search subscriptions
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {SubscriptionSearchRequest} subscriptionSearchRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public searchSubscriptions(xAuthorization: string, xOrganization: string, subscriptionSearchRequest: SubscriptionSearchRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionsApiFp(this.configuration).searchSubscriptions(xAuthorization, xOrganization, subscriptionSearchRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Update subscription details
     * @summary Update subscription
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Subscription ID
     * @param {UpdateSubscriptionRequest} updateSubscriptionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public updateSubscription(xAuthorization: string, xOrganization: string, id: string, updateSubscriptionRequest: UpdateSubscriptionRequest, options?: RawAxiosRequestConfig) {
        return SubscriptionsApiFp(this.configuration).updateSubscription(xAuthorization, xOrganization, id, updateSubscriptionRequest, options).then((request) => request(this.axios, this.basePath));
    }
}



/**
 * TransactionsApi - axios parameter creator
 */
export const TransactionsApiAxiosParamCreator = function (configuration?: Configuration) {
    return {
        /**
         * Create a new transaction
         * @summary Create transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateTransactionRequest} createTransactionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createTransaction: async (xAuthorization: string, xOrganization: string, createTransactionRequest: CreateTransactionRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('createTransaction', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('createTransaction', 'xOrganization', xOrganization)
            // verify required parameter 'createTransactionRequest' is not null or undefined
            assertParamExists('createTransaction', 'createTransactionRequest', createTransactionRequest)
            const localVarPath = `/transaction`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(createTransactionRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Get transaction by ID
         * @summary Get transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getTransaction: async (xAuthorization: string, xOrganization: string, id: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('getTransaction', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('getTransaction', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('getTransaction', 'id', id)
            const localVarPath = `/transaction/{id}`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'GET', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Refund a transaction (full refund only)
         * @summary Refund transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {object} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        refundTransaction: async (xAuthorization: string, xOrganization: string, id: string, body?: object, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('refundTransaction', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('refundTransaction', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('refundTransaction', 'id', id)
            const localVarPath = `/transaction/{id}/refund`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(body, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Search for transactions with optional filters and pagination
         * @summary Search transactions
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {TransactionSearchRequest} transactionSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchTransactions: async (xAuthorization: string, xOrganization: string, transactionSearchRequest: TransactionSearchRequest, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('searchTransactions', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('searchTransactions', 'xOrganization', xOrganization)
            // verify required parameter 'transactionSearchRequest' is not null or undefined
            assertParamExists('searchTransactions', 'transactionSearchRequest', transactionSearchRequest)
            const localVarPath = `/transaction/search`;
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            localVarHeaderParameter['Content-Type'] = 'application/json';

            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};
            localVarRequestOptions.data = serializeDataIfNeeded(transactionSearchRequest, localVarRequestOptions, configuration)

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
        /**
         * Void a transaction that hasn\'t been settled
         * @summary Void transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        voidTransaction: async (xAuthorization: string, xOrganization: string, id: string, options: RawAxiosRequestConfig = {}): Promise<RequestArgs> => {
            // verify required parameter 'xAuthorization' is not null or undefined
            assertParamExists('voidTransaction', 'xAuthorization', xAuthorization)
            // verify required parameter 'xOrganization' is not null or undefined
            assertParamExists('voidTransaction', 'xOrganization', xOrganization)
            // verify required parameter 'id' is not null or undefined
            assertParamExists('voidTransaction', 'id', id)
            const localVarPath = `/transaction/{id}/void`
                .replace(`{${"id"}}`, encodeURIComponent(String(id)));
            // use dummy base URL string because the URL constructor only accepts absolute URLs.
            const localVarUrlObj = new URL(localVarPath, DUMMY_BASE_URL);
            let baseOptions;
            if (configuration) {
                baseOptions = configuration.baseOptions;
            }

            const localVarRequestOptions = { method: 'POST', ...baseOptions, ...options};
            const localVarHeaderParameter = {} as any;
            const localVarQueryParameter = {} as any;


    
            if (xAuthorization != null) {
                localVarHeaderParameter['X-Authorization'] = String(xAuthorization);
            }
            if (xOrganization != null) {
                localVarHeaderParameter['X-Organization'] = String(xOrganization);
            }
            setSearchParams(localVarUrlObj, localVarQueryParameter);
            let headersFromBaseOptions = baseOptions && baseOptions.headers ? baseOptions.headers : {};
            localVarRequestOptions.headers = {...localVarHeaderParameter, ...headersFromBaseOptions, ...options.headers};

            return {
                url: toPathString(localVarUrlObj),
                options: localVarRequestOptions,
            };
        },
    }
};

/**
 * TransactionsApi - functional programming interface
 */
export const TransactionsApiFp = function(configuration?: Configuration) {
    const localVarAxiosParamCreator = TransactionsApiAxiosParamCreator(configuration)
    return {
        /**
         * Create a new transaction
         * @summary Create transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateTransactionRequest} createTransactionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async createTransaction(xAuthorization: string, xOrganization: string, createTransactionRequest: CreateTransactionRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TransactionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.createTransaction(xAuthorization, xOrganization, createTransactionRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['TransactionsApi.createTransaction']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Get transaction by ID
         * @summary Get transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async getTransaction(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TransactionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.getTransaction(xAuthorization, xOrganization, id, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['TransactionsApi.getTransaction']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Refund a transaction (full refund only)
         * @summary Refund transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {object} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async refundTransaction(xAuthorization: string, xOrganization: string, id: string, body?: object, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TransactionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.refundTransaction(xAuthorization, xOrganization, id, body, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['TransactionsApi.refundTransaction']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Search for transactions with optional filters and pagination
         * @summary Search transactions
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {TransactionSearchRequest} transactionSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async searchTransactions(xAuthorization: string, xOrganization: string, transactionSearchRequest: TransactionSearchRequest, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TransactionSearchResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.searchTransactions(xAuthorization, xOrganization, transactionSearchRequest, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['TransactionsApi.searchTransactions']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
        /**
         * Void a transaction that hasn\'t been settled
         * @summary Void transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        async voidTransaction(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): Promise<(axios?: AxiosInstance, basePath?: string) => AxiosPromise<TransactionResponse>> {
            const localVarAxiosArgs = await localVarAxiosParamCreator.voidTransaction(xAuthorization, xOrganization, id, options);
            const localVarOperationServerIndex = configuration?.serverIndex ?? 0;
            const localVarOperationServerBasePath = operationServerMap['TransactionsApi.voidTransaction']?.[localVarOperationServerIndex]?.url;
            return (axios, basePath) => createRequestFunction(localVarAxiosArgs, globalAxios, BASE_PATH, configuration)(axios, localVarOperationServerBasePath || basePath);
        },
    }
};

/**
 * TransactionsApi - factory interface
 */
export const TransactionsApiFactory = function (configuration?: Configuration, basePath?: string, axios?: AxiosInstance) {
    const localVarFp = TransactionsApiFp(configuration)
    return {
        /**
         * Create a new transaction
         * @summary Create transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {CreateTransactionRequest} createTransactionRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        createTransaction(xAuthorization: string, xOrganization: string, createTransactionRequest: CreateTransactionRequest, options?: RawAxiosRequestConfig): AxiosPromise<TransactionResponse> {
            return localVarFp.createTransaction(xAuthorization, xOrganization, createTransactionRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Get transaction by ID
         * @summary Get transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        getTransaction(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): AxiosPromise<TransactionResponse> {
            return localVarFp.getTransaction(xAuthorization, xOrganization, id, options).then((request) => request(axios, basePath));
        },
        /**
         * Refund a transaction (full refund only)
         * @summary Refund transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {object} [body] 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        refundTransaction(xAuthorization: string, xOrganization: string, id: string, body?: object, options?: RawAxiosRequestConfig): AxiosPromise<TransactionResponse> {
            return localVarFp.refundTransaction(xAuthorization, xOrganization, id, body, options).then((request) => request(axios, basePath));
        },
        /**
         * Search for transactions with optional filters and pagination
         * @summary Search transactions
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {TransactionSearchRequest} transactionSearchRequest 
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        searchTransactions(xAuthorization: string, xOrganization: string, transactionSearchRequest: TransactionSearchRequest, options?: RawAxiosRequestConfig): AxiosPromise<TransactionSearchResponse> {
            return localVarFp.searchTransactions(xAuthorization, xOrganization, transactionSearchRequest, options).then((request) => request(axios, basePath));
        },
        /**
         * Void a transaction that hasn\'t been settled
         * @summary Void transaction
         * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
         * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
         * @param {string} id Transaction ID
         * @param {*} [options] Override http request option.
         * @throws {RequiredError}
         */
        voidTransaction(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig): AxiosPromise<TransactionResponse> {
            return localVarFp.voidTransaction(xAuthorization, xOrganization, id, options).then((request) => request(axios, basePath));
        },
    };
};

/**
 * TransactionsApi - object-oriented interface
 */
export class TransactionsApi extends BaseAPI {
    /**
     * Create a new transaction
     * @summary Create transaction
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {CreateTransactionRequest} createTransactionRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public createTransaction(xAuthorization: string, xOrganization: string, createTransactionRequest: CreateTransactionRequest, options?: RawAxiosRequestConfig) {
        return TransactionsApiFp(this.configuration).createTransaction(xAuthorization, xOrganization, createTransactionRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Get transaction by ID
     * @summary Get transaction
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Transaction ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public getTransaction(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig) {
        return TransactionsApiFp(this.configuration).getTransaction(xAuthorization, xOrganization, id, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Refund a transaction (full refund only)
     * @summary Refund transaction
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Transaction ID
     * @param {object} [body] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public refundTransaction(xAuthorization: string, xOrganization: string, id: string, body?: object, options?: RawAxiosRequestConfig) {
        return TransactionsApiFp(this.configuration).refundTransaction(xAuthorization, xOrganization, id, body, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Search for transactions with optional filters and pagination
     * @summary Search transactions
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {TransactionSearchRequest} transactionSearchRequest 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public searchTransactions(xAuthorization: string, xOrganization: string, transactionSearchRequest: TransactionSearchRequest, options?: RawAxiosRequestConfig) {
        return TransactionsApiFp(this.configuration).searchTransactions(xAuthorization, xOrganization, transactionSearchRequest, options).then((request) => request(this.axios, this.basePath));
    }

    /**
     * Void a transaction that hasn\'t been settled
     * @summary Void transaction
     * @param {string} xAuthorization Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;)
     * @param {string} xOrganization Organization ID that must match the integration\&#39;s organization
     * @param {string} id Transaction ID
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    public voidTransaction(xAuthorization: string, xOrganization: string, id: string, options?: RawAxiosRequestConfig) {
        return TransactionsApiFp(this.configuration).voidTransaction(xAuthorization, xOrganization, id, options).then((request) => request(this.axios, this.basePath));
    }
}



