# AuthenticationApi

All URIs are relative to *https://api.mywell.org/api/v2*

|Method | HTTP request | Description|
|------------- | ------------- | -------------|
|[**useAccessToken**](#useaccesstoken) | **GET** /auth/access | Initial token exchange|
|[**useRefreshToken**](#userefreshtoken) | **GET** /auth/refresh | Refresh token|

# **useAccessToken**
> TokenResponse useAccessToken()

One-time use endpoint for initial token exchange. Only works when integration is disabled. After successful use, the integration is enabled and this endpoint becomes unusable.  **Note:** The X-Organization header is NOT required for this endpoint. The organization ID is returned in the response. 

### Example

```typescript
import {
    AuthenticationApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new AuthenticationApi(configuration);

let aCCESSTOKEN: string; //Access token from integration creation (default to undefined)

const { status, data } = await apiInstance.useAccessToken(
    aCCESSTOKEN
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **aCCESSTOKEN** | [**string**] | Access token from integration creation | defaults to undefined|


### Return type

**TokenResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Successful token exchange |  -  |
|**400** | Bad request |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **useRefreshToken**
> TokenResponse useRefreshToken()

Get new tokens using refresh token

### Example

```typescript
import {
    AuthenticationApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new AuthenticationApi(configuration);

let rEFRESHTOKEN: string; //Refresh token from previous token exchange (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)

const { status, data } = await apiInstance.useRefreshToken(
    rEFRESHTOKEN,
    xOrganization
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **rEFRESHTOKEN** | [**string**] | Refresh token from previous token exchange | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**TokenResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Successful token refresh |  -  |
|**400** | Bad request |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

