# CampusesApi

All URIs are relative to *https://api.mywell.org/api/v2*

|Method | HTTP request | Description|
|------------- | ------------- | -------------|
|[**searchCampuses**](#searchcampuses) | **POST** /campus/search | Search campuses|

# **searchCampuses**
> CampusSearchResponse searchCampuses(campusSearchRequest)

Search for campuses with optional filters and pagination

### Example

```typescript
import {
    CampusesApi,
    Configuration,
    CampusSearchRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CampusesApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let campusSearchRequest: CampusSearchRequest; //

const { status, data } = await apiInstance.searchCampuses(
    xAuthorization,
    xOrganization,
    campusSearchRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **campusSearchRequest** | **CampusSearchRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**CampusSearchResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

