# CreateSubscriptionRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**amount** | **number** | Subscription amount in cents (minimum 100 cents &#x3D; $1.00) | [default to undefined]
**frequency** | **string** |  | [default to undefined]
**startDate** | **string** | Start date in YYYY-MM-DD format | [default to undefined]
**customerId** | **string** |  | [default to undefined]
**paymentMethodId** | **string** | Payment method database ID | [default to undefined]
**campusId** | **string** | Campus ID (defaults to oldest active campus with active funds if not provided) | [optional] [default to undefined]
**fundId** | **string** | Single fund ID (mutually exclusive with funds) | [optional] [default to undefined]
**funds** | [**Array&lt;FundAllocation&gt;**](FundAllocation.md) | Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled) | [optional] [default to undefined]
**description** | **string** |  | [optional] [default to undefined]
**feesCovered** | **boolean** | Whether donor covers processing fees | [optional] [default to false]

## Example

```typescript
import { CreateSubscriptionRequest } from 'mywell-api-sdk';

const instance: CreateSubscriptionRequest = {
    amount,
    frequency,
    startDate,
    customerId,
    paymentMethodId,
    campusId,
    fundId,
    funds,
    description,
    feesCovered,
};
```

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)
