# CreateTransactionRequest


## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**amount** | **number** | Amount in cents (minimum 1 cent &#x3D; $0.01) | [default to undefined]
**customerId** | **string** |  | [default to undefined]
**paymentMethodId** | **string** | Payment method database ID | [default to undefined]
**campusId** | **string** | Campus ID (defaults to oldest active campus with active funds if not provided) | [optional] [default to undefined]
**fundId** | **string** | Single fund ID (mutually exclusive with funds) | [optional] [default to undefined]
**funds** | [**Array&lt;FundAllocation&gt;**](FundAllocation.md) | Multi-fund allocations (mutually exclusive with fundId, requires multi-fund giving enabled) | [optional] [default to undefined]
**description** | **string** |  | [optional] [default to undefined]
**feesCovered** | **boolean** | Whether customer covers processing fees | [optional] [default to false]

## Example

```typescript
import { CreateTransactionRequest } from 'mywell-api-sdk';

const instance: CreateTransactionRequest = {
    amount,
    customerId,
    paymentMethodId,
    campusId,
    fundId,
    funds,
    description,
    feesCovered,
};
```

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)
