# CustomersApi

All URIs are relative to *https://api.mywell.org/api/v2*

|Method | HTTP request | Description|
|------------- | ------------- | -------------|
|[**addPaymentMethod**](#addpaymentmethod) | **POST** /customer/{id}/paymentMethod | Add payment method|
|[**createCustomer**](#createcustomer) | **POST** /customer | Create customer|
|[**createCustomerAddress**](#createcustomeraddress) | **POST** /customer/{id}/address | Create customer address|
|[**deleteCustomerAddress**](#deletecustomeraddress) | **DELETE** /customer/{id}/address/{id2} | Delete customer address|
|[**deletePaymentMethod**](#deletepaymentmethod) | **DELETE** /customer/{id}/paymentMethod/{id2} | Delete payment method|
|[**getCustomer**](#getcustomer) | **GET** /customer/{id} | Get customer|
|[**getCustomerAddresses**](#getcustomeraddresses) | **GET** /customer/{id}/address | Get customer addresses|
|[**getCustomerPaymentMethods**](#getcustomerpaymentmethods) | **GET** /customer/{id}/paymentMethod | Get customer payment methods|
|[**searchCustomers**](#searchcustomers) | **POST** /customer/search | Search customers|
|[**updateCustomer**](#updatecustomer) | **PUT** /customer/{id} | Update customer|

# **addPaymentMethod**
> PaymentMethod addPaymentMethod(addPaymentMethodRequest)

Add a payment method to a customer

### Example

```typescript
import {
    CustomersApi,
    Configuration,
    AddPaymentMethodRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)
let addPaymentMethodRequest: AddPaymentMethodRequest; //

const { status, data } = await apiInstance.addPaymentMethod(
    xAuthorization,
    xOrganization,
    id,
    addPaymentMethodRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **addPaymentMethodRequest** | **AddPaymentMethodRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|


### Return type

**PaymentMethod**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Payment method added successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **createCustomer**
> CustomerResponse createCustomer(createCustomerRequest)

Create a new customer with payment method

### Example

```typescript
import {
    CustomersApi,
    Configuration,
    CreateCustomerRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let createCustomerRequest: CreateCustomerRequest; //

const { status, data } = await apiInstance.createCustomer(
    xAuthorization,
    xOrganization,
    createCustomerRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **createCustomerRequest** | **CreateCustomerRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**CustomerResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Customer created successfully |  -  |
|**400** | Bad request |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **createCustomerAddress**
> Address createCustomerAddress(createAddressRequest)

Create a new address for a customer

### Example

```typescript
import {
    CustomersApi,
    Configuration,
    CreateAddressRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)
let createAddressRequest: CreateAddressRequest; //

const { status, data } = await apiInstance.createCustomerAddress(
    xAuthorization,
    xOrganization,
    id,
    createAddressRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **createAddressRequest** | **CreateAddressRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|


### Return type

**Address**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Address created successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deleteCustomerAddress**
> DeletePaymentMethod200Response deleteCustomerAddress()

Delete an address from a customer

### Example

```typescript
import {
    CustomersApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)
let id2: string; //Address ID (default to undefined)

const { status, data } = await apiInstance.deleteCustomerAddress(
    xAuthorization,
    xOrganization,
    id,
    id2
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|
| **id2** | [**string**] | Address ID | defaults to undefined|


### Return type

**DeletePaymentMethod200Response**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Address deleted successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **deletePaymentMethod**
> DeletePaymentMethod200Response deletePaymentMethod()

Delete a payment method from a customer

### Example

```typescript
import {
    CustomersApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)
let id2: string; //Payment method ID (default to undefined)

const { status, data } = await apiInstance.deletePaymentMethod(
    xAuthorization,
    xOrganization,
    id,
    id2
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|
| **id2** | [**string**] | Payment method ID | defaults to undefined|


### Return type

**DeletePaymentMethod200Response**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Payment method deleted successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getCustomer**
> CustomerResponse getCustomer()

Get customer by ID

### Example

```typescript
import {
    CustomersApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)

const { status, data } = await apiInstance.getCustomer(
    xAuthorization,
    xOrganization,
    id
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|


### Return type

**CustomerResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Customer details |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getCustomerAddresses**
> AddressListResponse getCustomerAddresses()

Get all addresses for a customer

### Example

```typescript
import {
    CustomersApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)

const { status, data } = await apiInstance.getCustomerAddresses(
    xAuthorization,
    xOrganization,
    id
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|


### Return type

**AddressListResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | List of addresses |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getCustomerPaymentMethods**
> PaymentMethodListResponse getCustomerPaymentMethods()

Get all payment methods for a customer

### Example

```typescript
import {
    CustomersApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)

const { status, data } = await apiInstance.getCustomerPaymentMethods(
    xAuthorization,
    xOrganization,
    id
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|


### Return type

**PaymentMethodListResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | List of payment methods |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **searchCustomers**
> CustomerSearchResponse searchCustomers(customerSearchRequest)

Search for customers with optional filters and pagination

### Example

```typescript
import {
    CustomersApi,
    Configuration,
    CustomerSearchRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let customerSearchRequest: CustomerSearchRequest; //

const { status, data } = await apiInstance.searchCustomers(
    xAuthorization,
    xOrganization,
    customerSearchRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **customerSearchRequest** | **CustomerSearchRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**CustomerSearchResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateCustomer**
> CustomerResponse updateCustomer(updateCustomerRequest)

Update customer information

### Example

```typescript
import {
    CustomersApi,
    Configuration,
    UpdateCustomerRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new CustomersApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Customer ID (default to undefined)
let updateCustomerRequest: UpdateCustomerRequest; //

const { status, data } = await apiInstance.updateCustomer(
    xAuthorization,
    xOrganization,
    id,
    updateCustomerRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **updateCustomerRequest** | **UpdateCustomerRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Customer ID | defaults to undefined|


### Return type

**CustomerResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Customer updated successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

