# FundsApi

All URIs are relative to *https://api.mywell.org/api/v2*

|Method | HTTP request | Description|
|------------- | ------------- | -------------|
|[**searchFunds**](#searchfunds) | **POST** /fund/search | Search funds|

# **searchFunds**
> FundSearchResponse searchFunds(fundSearchRequest)

Search for funds with optional filters and pagination

### Example

```typescript
import {
    FundsApi,
    Configuration,
    FundSearchRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new FundsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let fundSearchRequest: FundSearchRequest; //

const { status, data } = await apiInstance.searchFunds(
    xAuthorization,
    xOrganization,
    fundSearchRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **fundSearchRequest** | **FundSearchRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**FundSearchResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

