# SubscriptionsApi

All URIs are relative to *https://api.mywell.org/api/v2*

|Method | HTTP request | Description|
|------------- | ------------- | -------------|
|[**createSubscription**](#createsubscription) | **POST** /subscription | Create subscription|
|[**getSubscription**](#getsubscription) | **GET** /subscription/{id} | Get subscription|
|[**searchSubscriptions**](#searchsubscriptions) | **POST** /subscription/search | Search subscriptions|
|[**updateSubscription**](#updatesubscription) | **PUT** /subscription/{id} | Update subscription|

# **createSubscription**
> SubscriptionResponse createSubscription(createSubscriptionRequest)

Create a new subscription

### Example

```typescript
import {
    SubscriptionsApi,
    Configuration,
    CreateSubscriptionRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new SubscriptionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let createSubscriptionRequest: CreateSubscriptionRequest; //

const { status, data } = await apiInstance.createSubscription(
    xAuthorization,
    xOrganization,
    createSubscriptionRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **createSubscriptionRequest** | **CreateSubscriptionRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**SubscriptionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Subscription created successfully |  -  |
|**400** | Bad request |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getSubscription**
> SubscriptionResponse getSubscription()

Get subscription by ID

### Example

```typescript
import {
    SubscriptionsApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new SubscriptionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Subscription ID (default to undefined)

const { status, data } = await apiInstance.getSubscription(
    xAuthorization,
    xOrganization,
    id
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Subscription ID | defaults to undefined|


### Return type

**SubscriptionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Subscription details |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **searchSubscriptions**
> SubscriptionSearchResponse searchSubscriptions(subscriptionSearchRequest)

Search for subscriptions with optional filters and pagination

### Example

```typescript
import {
    SubscriptionsApi,
    Configuration,
    SubscriptionSearchRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new SubscriptionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let subscriptionSearchRequest: SubscriptionSearchRequest; //

const { status, data } = await apiInstance.searchSubscriptions(
    xAuthorization,
    xOrganization,
    subscriptionSearchRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **subscriptionSearchRequest** | **SubscriptionSearchRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**SubscriptionSearchResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **updateSubscription**
> SubscriptionResponse updateSubscription(updateSubscriptionRequest)

Update subscription details

### Example

```typescript
import {
    SubscriptionsApi,
    Configuration,
    UpdateSubscriptionRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new SubscriptionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Subscription ID (default to undefined)
let updateSubscriptionRequest: UpdateSubscriptionRequest; //

const { status, data } = await apiInstance.updateSubscription(
    xAuthorization,
    xOrganization,
    id,
    updateSubscriptionRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **updateSubscriptionRequest** | **UpdateSubscriptionRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Subscription ID | defaults to undefined|


### Return type

**SubscriptionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Subscription updated successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

