# TransactionsApi

All URIs are relative to *https://api.mywell.org/api/v2*

|Method | HTTP request | Description|
|------------- | ------------- | -------------|
|[**createTransaction**](#createtransaction) | **POST** /transaction | Create transaction|
|[**getTransaction**](#gettransaction) | **GET** /transaction/{id} | Get transaction|
|[**refundTransaction**](#refundtransaction) | **POST** /transaction/{id}/refund | Refund transaction|
|[**searchTransactions**](#searchtransactions) | **POST** /transaction/search | Search transactions|
|[**voidTransaction**](#voidtransaction) | **POST** /transaction/{id}/void | Void transaction|

# **createTransaction**
> TransactionResponse createTransaction(createTransactionRequest)

Create a new transaction

### Example

```typescript
import {
    TransactionsApi,
    Configuration,
    CreateTransactionRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new TransactionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let createTransactionRequest: CreateTransactionRequest; //

const { status, data } = await apiInstance.createTransaction(
    xAuthorization,
    xOrganization,
    createTransactionRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **createTransactionRequest** | **CreateTransactionRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**TransactionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Transaction created successfully |  -  |
|**400** | Bad request |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **getTransaction**
> TransactionResponse getTransaction()

Get transaction by ID

### Example

```typescript
import {
    TransactionsApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new TransactionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Transaction ID (default to undefined)

const { status, data } = await apiInstance.getTransaction(
    xAuthorization,
    xOrganization,
    id
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Transaction ID | defaults to undefined|


### Return type

**TransactionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Transaction details |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **refundTransaction**
> TransactionResponse refundTransaction()

Refund a transaction (full refund only)

### Example

```typescript
import {
    TransactionsApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new TransactionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Transaction ID (default to undefined)
let body: object; // (optional)

const { status, data } = await apiInstance.refundTransaction(
    xAuthorization,
    xOrganization,
    id,
    body
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **body** | **object**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Transaction ID | defaults to undefined|


### Return type

**TransactionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Transaction refunded successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **searchTransactions**
> TransactionSearchResponse searchTransactions(transactionSearchRequest)

Search for transactions with optional filters and pagination

### Example

```typescript
import {
    TransactionsApi,
    Configuration,
    TransactionSearchRequest
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new TransactionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let transactionSearchRequest: TransactionSearchRequest; //

const { status, data } = await apiInstance.searchTransactions(
    xAuthorization,
    xOrganization,
    transactionSearchRequest
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **transactionSearchRequest** | **TransactionSearchRequest**|  | |
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|


### Return type

**TransactionSearchResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Search results |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **voidTransaction**
> TransactionResponse voidTransaction()

Void a transaction that hasn\'t been settled

### Example

```typescript
import {
    TransactionsApi,
    Configuration
} from 'mywell-api-sdk';

const configuration = new Configuration();
const apiInstance = new TransactionsApi(configuration);

let xAuthorization: string; //Bearer token for authentication (format: \"Bearer YOUR_TOKEN\") (default to undefined)
let xOrganization: string; //Organization ID that must match the integration\'s organization (default to undefined)
let id: string; //Transaction ID (default to undefined)

const { status, data } = await apiInstance.voidTransaction(
    xAuthorization,
    xOrganization,
    id
);
```

### Parameters

|Name | Type | Description  | Notes|
|------------- | ------------- | ------------- | -------------|
| **xAuthorization** | [**string**] | Bearer token for authentication (format: \&quot;Bearer YOUR_TOKEN\&quot;) | defaults to undefined|
| **xOrganization** | [**string**] | Organization ID that must match the integration\&#39;s organization | defaults to undefined|
| **id** | [**string**] | Transaction ID | defaults to undefined|


### Return type

**TransactionResponse**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
|**200** | Transaction voided successfully |  -  |
|**400** | Bad request |  -  |
|**404** | Resource not found |  -  |
|**401** | Unauthorized |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

